/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.promise;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.riversun.promise.Action;
import org.riversun.promise.Func;
import org.riversun.promise.Log;
import org.riversun.promise.Status;
import org.riversun.promise.Thennable;

public class Promise
implements Thennable {
    private static final Logger LOGGER = Logger.getLogger(Promise.class.getName());
    private static final String TAG = Promise.class.getSimpleName();
    private Status mStatus = Status.PENDING;
    public String mName = "";
    private ExecutorService mExecutor = null;
    private boolean mIsExecutorAutoShutdown = true;
    private Promise mFounder = null;
    private Promise mParentPromise = null;
    private Promise mPreviousPromise;
    private Promise mNextPromise;
    private Promise mOnFulfilled = null;
    private Promise mOnRejected = null;
    private Object mResult;
    private Func mFunc;

    public Promise() {
    }

    private String getName() {
        return this.mName;
    }

    public Promise(String name, Func func, ExecutorService executor) {
        this();
        if (name == null) {
            name = this.toString();
        }
        this.mName = name;
        this.mFunc = func;
        if (executor != null) {
            this.mExecutor = executor;
            this.mIsExecutorAutoShutdown = false;
        }
        LOGGER.fine(TAG + " " + this.getName() + " construct() func=" + this.mFunc + ", executor=" + executor);
    }

    public Promise(String name, ExecutorService executor) {
        this(name, null, executor);
    }

    public Promise(ExecutorService executor) {
        this(null, null, executor);
    }

    public Promise(Func func, ExecutorService executor) {
        this(null, func, executor);
    }

    public Promise(String name, Func func) {
        this(name, func, null);
    }

    public Promise(Func func) {
        this(null, func, null);
    }

    public ExecutorService createExecutor() {
        ExecutorService executor = Executors.newCachedThreadPool();
        LOGGER.fine(TAG + " " + this.getName() + "#createExecutor created executor=" + executor);
        return executor;
    }

    @Override
    public Promise then(Func ... funcs) {
        LOGGER.fine(TAG + " " + this.getName() + "#then(funcs) funcs=" + funcs);
        ArrayList<Promise> promiseList = new ArrayList<Promise>();
        if (funcs != null) {
            for (Func func : funcs) {
                Promise promise = func == null ? null : new Promise(func);
                promiseList.add(promise);
            }
        }
        return this.then(promiseList.toArray(new Promise[0]));
    }

    @Override
    public Promise always(Thennable promise) {
        LOGGER.fine(TAG + " " + this.getName() + "#always promise=" + promise);
        return this.then(promise, promise);
    }

    @Override
    public Promise always(Func func) {
        Promise promise = new Promise(func);
        return this.always(promise);
    }

    @Override
    public Promise then(Thennable ... promises) {
        LOGGER.fine(TAG + " " + this.getName() + "#then(promises) promises=" + promises);
        Thennable onFulfilled = null;
        Thennable onRejected = null;
        if (promises != null && promises.length > 0) {
            onFulfilled = promises[0];
            if (promises.length > 1) {
                onRejected = promises[1];
            }
        }
        if (this.mExecutor == null) {
            this.mExecutor = this.createExecutor();
            LOGGER.fine(TAG + " " + this.getName() + "#then(promises) executor for ths promise is created=" + this.mExecutor);
        }
        if (this.mFounder == null) {
            this.mFounder = this;
        }
        this.mNextPromise = this.createNextPromise("NextPromise-of-" + this.mName + ")", (Promise)onFulfilled, (Promise)onRejected);
        LOGGER.fine(TAG + " " + this.getName() + "#then(promises) createNextPromise from onFulfilled=" + onFulfilled + " and onRejected=" + onRejected + " result next promise =" + this.mNextPromise);
        return this.mNextPromise;
    }

    @Override
    public Promise start() {
        LOGGER.fine(TAG + " " + this.getName() + "#start mFounder=" + this.mFounder);
        this.mFounder.ignite();
        return this;
    }

    private void ignite() {
        LOGGER.fine(TAG + " " + this.getName() + "#ignite mPreviousPromise=" + this.mPreviousPromise);
        if (this.mPreviousPromise == null) {
            LOGGER.fine(TAG + " " + this.getName() + "#ignite first call! on " + Thread.currentThread());
            this.runOnThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOGGER.fine(TAG + " " + Promise.this.getName() + "#ignite first call doNext mNextPromise=" + Promise.this.mNextPromise + " mResult=" + Promise.this.mResult);
                        Promise.this.doNext(Promise.this.mNextPromise, Promise.this.mResult);
                    }
                    catch (Exception e) {
                        if (Promise.this.mExecutor != null && Promise.this.mIsExecutorAutoShutdown) {
                            Promise.this.mExecutor.shutdown();
                        }
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void invokeFunction(Object previousPromiseResult) {
        try {
            this.mFunc.run(new Action(){

                @Override
                public void resolve(Object result) {
                    Promise.this.mStatus = Status.FULFILLED;
                    Promise.this.onFinish(result);
                }

                @Override
                public void reject(Object result) {
                    Promise.this.mStatus = Status.REJECTED;
                    Promise.this.onFinish(result);
                }

                @Override
                public void resolve() {
                    this.resolve(null);
                }

                @Override
                public void reject() {
                    this.reject(null);
                }
            }, previousPromiseResult);
        }
        catch (Exception e) {
            this.mStatus = Status.REJECTED;
            this.onFinish(e);
        }
    }

    private void onFinish(Object result) {
        Object crrResult = result;
        Promise nextPromise = this.mParentPromise.mNextPromise;
        LOGGER.fine(TAG + " " + this.getName() + "#onFinish result=" + result + " nextPromise=" + nextPromise);
        if (nextPromise != null) {
            this.doNext(nextPromise, crrResult);
        } else if (this.mParentPromise.mIsExecutorAutoShutdown) {
            LOGGER.fine(TAG + " " + this.getName() + "#onFinish executor(" + this.mParentPromise.mExecutor + ")  SHUTDOWN!!");
            this.mParentPromise.mExecutor.shutdown();
        } else {
            LOGGER.fine(TAG + " " + this.getName() + "#onFinish executor(" + this.mParentPromise.mExecutor + ")  It is a phase to SHUTDOWN, but does NOT SHUTDOWN because the original executor is set.");
        }
    }

    private void doNext(Promise nextPromise, Object crrResult) {
        LOGGER.fine(TAG + " " + this.getName() + "#doNext mStatus=" + (Object)((Object)this.mStatus) + " crrResult=" + crrResult);
        if (Log.isLogEnabled() && crrResult != null && crrResult instanceof Exception) {
            LOGGER.fine(TAG + " " + this.getName() + "#doNext rejection detected.");
            ((Exception)crrResult).printStackTrace();
        }
        switch (this.mStatus) {
            case FULFILLED: {
                if (nextPromise.mOnFulfilled == null) {
                    Promise skipPromise;
                    nextPromise.mOnFulfilled = skipPromise = new Promise("skipper(fulfilled)", new Func(){

                        @Override
                        public void run(Action action, Object data) {
                            action.resolve(data);
                        }
                    });
                    nextPromise.mOnFulfilled.populateParentPromise(nextPromise);
                }
                try {
                    LOGGER.fine(TAG + " " + this.getName() + " RUNNING " + nextPromise.mOnFulfilled.getName() + " crrResult=" + crrResult + " on " + Thread.currentThread());
                    nextPromise.mOnFulfilled.invokeFunction(crrResult);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case REJECTED: {
                if (nextPromise.mOnRejected == null) {
                    Promise skipPromise;
                    nextPromise.mOnRejected = skipPromise = new Promise("skipper(rejected)", new Func(){

                        @Override
                        public void run(Action action, Object data) {
                            action.reject(data);
                        }
                    });
                    nextPromise.mOnRejected.populateParentPromise(nextPromise);
                }
                nextPromise.mOnRejected.invokeFunction(crrResult);
                break;
            }
            case PENDING: {
                throw new RuntimeException("Cannot proceed operation with PENDING promise, please call Promise.resolve to start chain.");
            }
        }
    }

    private Promise createNextPromise(String promiseName, Promise onFulfilled, Promise onRejected) {
        Promise nextPromise = new Promise(promiseName, (Func)null);
        nextPromise.mExecutor = this.mExecutor;
        nextPromise.mIsExecutorAutoShutdown = this.mIsExecutorAutoShutdown;
        nextPromise.mFounder = this.mFounder;
        nextPromise.mPreviousPromise = this;
        if (onFulfilled != null) {
            nextPromise.mOnFulfilled = onFulfilled;
            nextPromise.mOnFulfilled.populateParentPromise(nextPromise);
        }
        if (onRejected != null) {
            nextPromise.mOnRejected = onRejected;
            nextPromise.mOnRejected.populateParentPromise(nextPromise);
        }
        return nextPromise;
    }

    private void populateParentPromise(Promise parentPromise) {
        this.mParentPromise = parentPromise;
        this.mPreviousPromise = parentPromise.mPreviousPromise;
        this.mExecutor = parentPromise.mExecutor;
        this.mIsExecutorAutoShutdown = parentPromise.mIsExecutorAutoShutdown;
        this.mFounder = parentPromise.mFounder;
    }

    public void runOnThread(Runnable r) {
        this.mExecutor.submit(r);
    }

    @Override
    public Status getStatus() {
        return this.mStatus;
    }

    @Override
    public Object getValue() {
        return this.mResult;
    }

    public static Promise resolve(Object data, ExecutorService executor) {
        LOGGER.fine(TAG + " Promise.resolve data=" + data + " executor=" + executor);
        Promise promise = new Promise("Promise.Resolve.Created", executor);
        promise.mStatus = Status.FULFILLED;
        promise.mResult = data;
        return promise;
    }

    public static Promise resolve(Object data) {
        return Promise.resolve(data, null);
    }

    public static Promise resolve() {
        return Promise.resolve(null, null);
    }

    public static Promise reject(Object reason) {
        Promise promise = new Promise();
        promise.mStatus = Status.REJECTED;
        promise.mResult = reason;
        return promise;
    }

    public static Promise reject() {
        return Promise.reject(null);
    }

    public static Promise all(Thennable ... promises) {
        ExecutorService executor = null;
        return Promise.all(executor, promises);
    }

    public static Promise all(final ExecutorService executor, final Thennable ... promises) {
        LOGGER.fine(TAG + " Promise.all executor=" + executor + " promises=" + promises);
        final ExecutorService _executor = executor == null ? Executors.newCachedThreadPool() : executor;
        if (promises == null || promises.length == 0) {
            return Promise.resolve();
        }
        final ArrayList resultList = new ArrayList();
        final ArrayList resultHolderList = new ArrayList();
        final StringBuilder sbWorkersPromise = new StringBuilder();
        sbWorkersPromise.append("WorkersPromise[");
        for (Thennable _promise : promises) {
            Promise srcPromise = (Promise)_promise;
            sbWorkersPromise.append(srcPromise.getName() + ":");
        }
        sbWorkersPromise.append("]");
        String nameOfWorkersPromise = sbWorkersPromise.toString();
        Func funcWorkers = new Func(){

            public String toString() {
                return sbWorkersPromise.toString() + "'s function";
            }

            @Override
            public void run(Action _action, Object data) throws Exception {
                final CountDownLatch latch = new CountDownLatch(promises.length);
                final Holder rejectedHolder = new Holder();
                for (Thennable _promise : promises) {
                    final Promise srcPromise = (Promise)_promise;
                    LOGGER.fine(TAG + " Promise.all add promise=" + srcPromise.getName());
                    final Holder resultHolder = new Holder();
                    resultHolderList.add(resultHolder);
                    Promise workerPromise = new Promise(srcPromise.getName() + ".Starter", _executor);
                    workerPromise.mStatus = Status.FULFILLED;
                    workerPromise.then(srcPromise).then(new Promise("Promise.all [FULFILLED promise of " + srcPromise.getName() + "]", new Func(){

                        @Override
                        public void run(Action action, Object data) throws Exception {
                            resultHolder.result = data;
                            action.resolve();
                            LOGGER.fine(TAG + " Promise.all " + srcPromise.getName() + " FULFILLED on " + Thread.currentThread());
                            latch.countDown();
                        }
                    }), new Promise("Promise.all [REJECTED promise of " + srcPromise.getName() + "]", new Func(){

                        @Override
                        public void run(Action action, Object data) throws Exception {
                            rejectedHolder.rejected = true;
                            rejectedHolder.result = data;
                            resultHolder.result = data;
                            action.resolve();
                            LOGGER.fine(TAG + " Promise.all " + srcPromise.getName() + " REJECTED on " + Thread.currentThread());
                            for (int i = 0; i < promises.length; ++i) {
                                latch.countDown();
                            }
                        }
                    })).start();
                }
                latch.await();
                if (executor == null) {
                    _executor.shutdown();
                }
                boolean isRejected = rejectedHolder.rejected;
                Object rejectedResultObject = rejectedHolder.result;
                for (Holder holder : resultHolderList) {
                    resultList.add(holder.result);
                }
                if (isRejected) {
                    _action.reject(rejectedResultObject);
                } else {
                    _action.resolve(resultList);
                }
            }
        };
        Promise workersPromise = new Promise(nameOfWorkersPromise, funcWorkers);
        Promise starterOfWorkersPromise = new Promise(nameOfWorkersPromise + ".Starter", _executor);
        starterOfWorkersPromise.mStatus = Status.FULFILLED;
        return starterOfWorkersPromise.then(workersPromise);
    }

    public static Promise all(Func ... funcs) {
        return Promise.all(null, funcs);
    }

    public static Promise all(ExecutorService executor, Func ... funcs) {
        if (funcs == null || funcs.length == 0) {
            Object data = null;
            return Promise.resolve(data, executor);
        }
        ArrayList<Promise> promiseList = new ArrayList<Promise>();
        if (funcs != null) {
            for (Func func : funcs) {
                Promise promise = func == null ? null : new Promise(func);
                promiseList.add(promise);
            }
        }
        return Promise.all(executor, (Thennable[])promiseList.toArray(new Promise[0]));
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static final class Holder {
        public Object result;
        public boolean rejected = false;

        private Holder() {
        }
    }
}

