/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.promise;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.riversun.promise.Action;
import org.riversun.promise.Func;
import org.riversun.promise.PromiseException;
import org.riversun.promise.Status;
import org.riversun.promise.Thennable;

public class SyncPromise
implements Thennable {
    private final Func mFunc;
    private Status mStatus = Status.PENDING;
    private Object mResult;
    private SyncPromise mNextPromise;

    public SyncPromise() {
        this.mFunc = null;
    }

    public SyncPromise(Func executor) {
        this.mFunc = executor;
    }

    @Override
    public SyncPromise then(Func ... funcs) {
        ArrayList<SyncPromise> promiseList = new ArrayList<SyncPromise>();
        if (funcs != null) {
            for (Func func : funcs) {
                SyncPromise promise = new SyncPromise(func);
                promiseList.add(promise);
            }
        }
        return this.then(promiseList.toArray(new SyncPromise[0]));
    }

    @Override
    public SyncPromise then(Thennable ... promises) {
        Thennable onFulfilled = null;
        Thennable onRejected = null;
        if (promises != null && promises.length > 0) {
            onFulfilled = promises[0];
            if (promises.length > 1) {
                onRejected = promises[1];
            }
        } else {
            throw new RuntimeException("Please set  at least one Promise.");
        }
        if (this.mStatus == Status.FULFILLED) {
            this.mNextPromise = (SyncPromise)onFulfilled;
            if (this.mNextPromise != null && this.mNextPromise.mFunc != null) {
                this.invokeFunction(this.mNextPromise.mFunc, this.mResult);
            } else {
                SyncPromise skipPromise;
                this.mNextPromise = skipPromise = new SyncPromise(new Func(){

                    @Override
                    public void run(Action action, Object data) {
                        action.resolve(data);
                    }
                });
                this.invokeFunction(this.mNextPromise.mFunc, this.mResult);
                return this.mNextPromise;
            }
        }
        if (this.mStatus == Status.REJECTED) {
            this.mNextPromise = (SyncPromise)onRejected;
            if (this.mNextPromise != null && this.mNextPromise.mFunc != null) {
                this.invokeFunction(this.mNextPromise.mFunc, this.mResult);
            } else {
                SyncPromise skipPromise;
                this.mNextPromise = skipPromise = new SyncPromise(new Func(){

                    @Override
                    public void run(Action action, Object data) {
                        action.reject(data);
                    }
                });
                this.invokeFunction(this.mNextPromise.mFunc, this.mResult);
            }
        }
        return this.mNextPromise;
    }

    @Override
    public SyncPromise always(Func func) {
        SyncPromise promise = new SyncPromise(func);
        return this.always(promise);
    }

    @Override
    public SyncPromise always(Thennable promise) {
        return this.then(promise, promise);
    }

    @Override
    public SyncPromise start() {
        return this;
    }

    private void invokeFunction(Func func, Object previousPromiseResult) {
        final Semaphore semaphore = new Semaphore(0);
        try {
            func.run(new Action(){

                @Override
                public void resolve(Object result) {
                    SyncPromise.this.mNextPromise.mResult = result;
                    SyncPromise.this.mNextPromise.mStatus = Status.FULFILLED;
                    semaphore.release();
                }

                @Override
                public void reject(Object result) {
                    SyncPromise.this.mNextPromise.mResult = result;
                    SyncPromise.this.mNextPromise.mStatus = Status.REJECTED;
                    semaphore.release();
                }

                @Override
                public void resolve() {
                    this.resolve(null);
                }

                @Override
                public void reject() {
                    this.reject(null);
                }
            }, previousPromiseResult);
        }
        catch (Exception e) {
            this.mNextPromise.mResult = e;
            this.mNextPromise.mStatus = Status.REJECTED;
            semaphore.release();
        }
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.mNextPromise.mResult = null;
            this.mNextPromise.mStatus = Status.REJECTED;
        }
    }

    @Override
    public Status getStatus() {
        return this.mStatus;
    }

    @Override
    public Object getValue() {
        return this.mResult;
    }

    public static SyncPromise resolve(Object data) {
        SyncPromise promise = new SyncPromise();
        promise.mStatus = Status.FULFILLED;
        promise.mResult = data;
        return promise;
    }

    public static SyncPromise resolve() {
        return SyncPromise.resolve(null);
    }

    public static SyncPromise reject(Object reason) {
        SyncPromise promise = new SyncPromise();
        promise.mStatus = Status.REJECTED;
        promise.mResult = reason;
        return promise;
    }

    public static SyncPromise reject() {
        return SyncPromise.reject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyncPromise all(Thennable ... promises) {
        if (promises == null || promises.length == 0) {
            return SyncPromise.resolve();
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Future<SyncPromise>> futureList = new ArrayList<Future<SyncPromise>>();
        ArrayList<Object> resultList = new ArrayList<Object>();
        try {
            for (final Thennable thennable : promises) {
                Callable<SyncPromise> callable = new Callable<SyncPromise>(){

                    @Override
                    public SyncPromise call() throws Exception {
                        SyncPromise result = SyncPromise.resolve().then(thennable);
                        if (result.getStatus() == Status.REJECTED) {
                            throw new PromiseException(result.getValue());
                        }
                        return result;
                    }
                };
                Future<SyncPromise> future = executor.submit(callable);
                futureList.add(future);
            }
        }
        finally {
            executor.shutdown();
        }
        boolean rejected = false;
        Object rejectedError = null;
        for (Future future : futureList) {
            try {
                SyncPromise result = (SyncPromise)future.get();
                resultList.add(result.getValue());
            }
            catch (InterruptedException e) {
                break;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof PromiseException)) break;
                PromiseException pe = (PromiseException)cause;
                rejectedError = pe.getValue();
                rejected = true;
                break;
            }
        }
        if (rejected) {
            return SyncPromise.reject(rejectedError);
        }
        return SyncPromise.resolve(resultList);
    }

    public static SyncPromise all(Func ... funcs) {
        if (funcs == null || funcs.length == 0) {
            return SyncPromise.resolve();
        }
        ArrayList<SyncPromise> promiseList = new ArrayList<SyncPromise>();
        if (funcs != null) {
            for (Func func : funcs) {
                SyncPromise promise = new SyncPromise(func);
                promiseList.add(promise);
            }
        }
        return SyncPromise.all(promiseList.toArray(new SyncPromise[0]));
    }

    public static void sleep(long sleepMillis) {
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

