/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jaxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.riversun.jaxy.JaxyClientNetworkException;
import org.riversun.jaxy.JaxyConvJsonFromText;
import org.riversun.jaxy.JaxyConvXmlFromText;
import org.riversun.jaxy.JaxySrcGen4JsonNode;
import org.riversun.jaxy.JaxySrcGen4XmlNode;
import org.riversun.jaxy.JsonNode;
import org.riversun.jaxy.XmlNode;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxyClient {
    public static final String HTTP_METHOD_GET_METHOD = "GET";
    public static final String HTTP_METHOD_POST_METHOD = "POST";
    public static final String HTTPS_ALG_SSL = "SSL";
    public static final String HTTPS_ALG_TLS = "TLS";
    private static final String SUFFIX_HTTP = "http://";
    private static final String SUFFIX_HTTPS = "https://";
    private final JaxyConvXmlFromText xmlNodeTransform = new JaxyConvXmlFromText();
    private final JaxyConvJsonFromText mJaxyString2JsonNode = new JaxyConvJsonFromText();
    private String mProxyHost;
    private String mProxyPort = "0";
    private String mEncoding = "UTF-8";
    private String mEndpointUrl;
    private boolean mIsUseCDATA = false;
    private Map<String, String[]> mParameterMap;
    private Set<String> mNeedNotEncodeParameterNameSet;
    private String mHttpRequestMethod = "GET";
    private String mLatestRequestUrl;
    private int mTimeoutMillis = 5000;
    private boolean mIsUseBasicAuth = false;
    private String mBasicAuthUserName;
    private String mBasicAuthUsePassword;
    private String mSslAlgorithm = "TLS";
    private Map<String, List<String>> mRequestPropertyMap = null;
    public Set<String> mForceIndexedParameterNameSet = new HashSet<String>();
    private SourceCodeGenerator mSourceCodeGenerator;
    private final SourceGenTrigger mSourceGenTrigger = new SourceGenTrigger();

    public JaxyClient setSSLAlgorithm(String sslAlgorithm) {
        this.mSslAlgorithm = sslAlgorithm;
        return this;
    }

    public JaxyClient() {
        this.mParameterMap = new LinkedHashMap<String, String[]>();
        this.mNeedNotEncodeParameterNameSet = new HashSet<String>();
    }

    public JsonNode getJson() throws JaxyClientNetworkException {
        String jsonText;
        SourceGenTrigger trg = this.populateCurrentStatToTrigger(SourceGenTriggerMethod.FROM_NET);
        try {
            jsonText = this.getTextFormUrl(new URL(this.mEndpointUrl));
        }
        catch (MalformedURLException e) {
            throw new JaxyClientNetworkException(e);
        }
        JsonNode jsonNode = this.mJaxyString2JsonNode.toJsonNode(jsonText);
        return jsonNode;
    }

    public JsonNode getJson(String jsonText) {
        SourceGenTrigger trg = this.populateCurrentStatToTrigger(SourceGenTriggerMethod.FROM_TEXT);
        trg.text = jsonText;
        return this.mJaxyString2JsonNode.toJsonNode(jsonText);
    }

    public XmlNode getXml() throws JaxyClientNetworkException {
        SourceGenTrigger trg = this.populateCurrentStatToTrigger(SourceGenTriggerMethod.FROM_NET);
        XmlNode xmlNode = null;
        if (this.mEndpointUrl != null) {
            String xmlText;
            try {
                xmlText = this.getTextFormUrl(new URL(this.mEndpointUrl));
            }
            catch (MalformedURLException e) {
                throw new JaxyClientNetworkException(e);
            }
            xmlNode = this.xmlNodeTransform.toXmlNode(xmlText);
        }
        return xmlNode;
    }

    @Deprecated
    public XmlNode getXml(Document doc) {
        return this.xmlNodeTransform.toXmlNode(doc);
    }

    public XmlNode getXml(File file) {
        SourceGenTrigger trg = this.populateCurrentStatToTrigger(SourceGenTriggerMethod.FROM_FILE);
        trg.file = file;
        if (File.separator.equals("\\")) {
            // empty if block
        }
        return this.xmlNodeTransform.toXmlNode(file);
    }

    public XmlNode getXml(URL url) throws JaxyClientNetworkException {
        SourceGenTrigger trg = this.populateCurrentStatToTrigger(SourceGenTriggerMethod.FROM_NET);
        trg.endpointUrl = url.toString();
        String xmlText = this.getTextFormUrl(url);
        return this.xmlNodeTransform.toXmlNode(xmlText);
    }

    public XmlNode getXml(String xmlFormattedText) {
        SourceGenTrigger trg = this.populateCurrentStatToTrigger(SourceGenTriggerMethod.FROM_TEXT);
        trg.text = xmlFormattedText;
        return this.xmlNodeTransform.toXmlNode(xmlFormattedText);
    }

    public String getText() throws JaxyClientNetworkException {
        try {
            return this.getTextFormUrl(new URL(this.mEndpointUrl));
        }
        catch (MalformedURLException e) {
            throw new JaxyClientNetworkException(e);
        }
    }

    private SourceGenTrigger populateCurrentStatToTrigger(SourceGenTriggerMethod triggerMethod) {
        this.mSourceGenTrigger.clear();
        this.mSourceGenTrigger.triggerMethod = triggerMethod;
        this.mSourceGenTrigger.httpMethod = this.mHttpRequestMethod;
        this.mSourceGenTrigger.endpointUrl = this.mEndpointUrl;
        this.mSourceGenTrigger.useCDATA = this.mIsUseCDATA;
        this.mSourceGenTrigger.parameterMap = this.mParameterMap;
        boolean bl = this.mSourceGenTrigger.useProxy = this.mProxyHost != null;
        if (this.mSourceGenTrigger.useProxy) {
            this.mSourceGenTrigger.proxyHost = this.mProxyHost;
            this.mSourceGenTrigger.proxyPort = Integer.parseInt(this.mProxyPort);
        }
        this.mSourceGenTrigger.useBasicAuth = this.mIsUseBasicAuth;
        this.mSourceGenTrigger.basicAuthUser = this.mBasicAuthUserName;
        this.mSourceGenTrigger.basicAuthPassword = this.mBasicAuthUsePassword;
        this.mSourceGenTrigger.file = null;
        this.mSourceGenTrigger.text = null;
        return this.mSourceGenTrigger;
    }

    public JaxyClient setBasicAuthUserNameAndPassword(String userName, String password) {
        this.mBasicAuthUserName = userName;
        this.mBasicAuthUsePassword = password;
        return this;
    }

    public JaxyClient setUseBasicAuth(boolean useBasicAuth) {
        this.mIsUseBasicAuth = useBasicAuth;
        return this;
    }

    public JaxyClient setTimeoutMillis(int millis) {
        this.mTimeoutMillis = millis;
        return this;
    }

    public void setForceIndexedParameterName(String parameterName) {
        if (!this.mForceIndexedParameterNameSet.contains(parameterName)) {
            this.mForceIndexedParameterNameSet.add(parameterName);
        }
    }

    protected Map getParameterMap() {
        return this.mParameterMap;
    }

    public void setHttpMethod(String requestMethod) {
        this.mHttpRequestMethod = requestMethod;
    }

    public void addParameter(Map<String, String[]> parameterMap) {
        this.mParameterMap = parameterMap;
    }

    public void addParameter(String parameterName, String parameterValue) {
        this.mParameterMap.put(parameterName, new String[]{parameterValue});
    }

    public void addParameter(String parameterName, String parameterValue, boolean isNeedUrlEncodeParameterValue) {
        if (!isNeedUrlEncodeParameterValue) {
            this.mNeedNotEncodeParameterNameSet.add(parameterName);
        }
        this.mParameterMap.put(parameterName, new String[]{parameterValue});
    }

    public void addParameter(String parameterName, String[] parameterValue) {
        this.mParameterMap.put(parameterName, parameterValue);
    }

    public void addParameter(String parameterName, int intParameterValue) {
        String parameterValue = String.valueOf(intParameterValue);
        this.mParameterMap.put(parameterName, new String[]{parameterValue});
    }

    public void addParameter(String parameterName, long longParameterValue) {
        String parameterValue = String.valueOf(longParameterValue);
        this.mParameterMap.put(parameterName, new String[]{parameterValue});
    }

    public void addParameter(String parameterName, float floatParameterValue) {
        String parameterValue = String.valueOf(floatParameterValue);
        this.mParameterMap.put(parameterName, new String[]{parameterValue});
    }

    public void addParameter(String parameterName, double doubleParameterValue) {
        String parameterValue = String.valueOf(doubleParameterValue);
        this.mParameterMap.put(parameterName, new String[]{parameterValue});
    }

    public String getTextFormUrl(URL url) throws JaxyClientNetworkException {
        String endpointUrl = url.toString();
        String responseText = "";
        try {
            Set<String> keyset = this.mParameterMap.keySet();
            Iterator<String> iterator = keyset.iterator();
            StringBuffer queryParamSB = new StringBuffer();
            while (iterator.hasNext()) {
                String objKey = iterator.next();
                String[] objValues = this.mParameterMap.get(objKey);
                if (objValues == null || objValues.length <= 0) continue;
                for (int i = 0; i < objValues.length; ++i) {
                    queryParamSB.append(objKey);
                    queryParamSB.append("=");
                    if (this.mNeedNotEncodeParameterNameSet.contains(objKey)) {
                        queryParamSB.append(objValues[i]);
                    } else {
                        queryParamSB.append(URLEncoder.encode(objValues[i], this.mEncoding));
                    }
                    queryParamSB.append("&");
                }
            }
            String queryParamString = queryParamSB.toString();
            String requestUrl = null;
            if (queryParamString.length() > 0) {
                queryParamString = queryParamString.substring(0, queryParamString.length() - 1);
                requestUrl = endpointUrl + "?" + queryParamString;
            } else {
                requestUrl = endpointUrl;
            }
            if (requestUrl.startsWith(SUFFIX_HTTP)) {
                responseText = this.doHttpRequest(requestUrl);
            } else if (requestUrl.startsWith(SUFFIX_HTTPS)) {
                responseText = this.doHttpsRequest(requestUrl);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return responseText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doHttpsRequest(String requestUrl) throws JaxyClientNetworkException {
        this.initHTTPS();
        String proxyHost = this.mProxyHost;
        String proxyPort = this.mProxyPort;
        String encoding = this.mEncoding;
        if (this.mIsUseBasicAuth) {
            Authenticator.setDefault(new BasicAuthAuthenticator(this.mBasicAuthUserName, this.mBasicAuthUsePassword));
        }
        int iProxyPort = Integer.parseInt(proxyPort);
        HttpURLConnection httpURLConnection = null;
        BufferedReader br = null;
        InputStream is = null;
        InputStreamReader isr = null;
        StringBuffer sb = new StringBuffer("");
        try {
            PrintWriter writer;
            JaxyClientURLWrapper conn;
            String urlPart;
            String[] requestUrlSplit;
            String queryStringForPOSTMethod;
            if (proxyHost == null) {
                queryStringForPOSTMethod = "";
                if (this.mHttpRequestMethod.equals(HTTP_METHOD_POST_METHOD) && (requestUrlSplit = requestUrl.split("\\?")).length == 2) {
                    requestUrl = urlPart = requestUrlSplit[0];
                    queryStringForPOSTMethod = requestUrlSplit[1];
                }
                conn = new JaxyClientURLWrapper(requestUrl);
                httpURLConnection = (HttpsURLConnection)conn.openConnectionNoProxy();
                httpURLConnection.setConnectTimeout(this.mTimeoutMillis);
                httpURLConnection.setReadTimeout(this.mTimeoutMillis);
                this.setHeaderPropertiesToHttpUrlConnection(httpURLConnection);
                if (this.mHttpRequestMethod.equals(HTTP_METHOD_POST_METHOD)) {
                    httpURLConnection.setDoOutput(true);
                    writer = new PrintWriter(httpURLConnection.getOutputStream());
                    writer.print(queryStringForPOSTMethod);
                    writer.close();
                } else {
                    httpURLConnection.setRequestMethod(HTTP_METHOD_GET_METHOD);
                }
            } else {
                queryStringForPOSTMethod = "";
                if (this.mHttpRequestMethod.equals(HTTP_METHOD_POST_METHOD) && (requestUrlSplit = requestUrl.split("\\?")).length == 2) {
                    requestUrl = urlPart = requestUrlSplit[0];
                    queryStringForPOSTMethod = requestUrlSplit[1];
                }
                conn = new JaxyClientURLWrapper(requestUrl);
                httpURLConnection = (HttpsURLConnection)conn.openConnectionWithProxy(proxyHost, iProxyPort);
                httpURLConnection.setConnectTimeout(this.mTimeoutMillis);
                httpURLConnection.setReadTimeout(this.mTimeoutMillis);
                this.setHeaderPropertiesToHttpUrlConnection(httpURLConnection);
                if (this.mRequestPropertyMap != null) {
                    Set<String> headerNamesSet = this.mRequestPropertyMap.keySet();
                    for (String headerName : headerNamesSet) {
                        List<String> headerValueList = this.mRequestPropertyMap.get(headerName);
                        for (String headervalue : headerValueList) {
                            httpURLConnection.addRequestProperty(headerName, headervalue);
                        }
                    }
                }
                if (this.mHttpRequestMethod.equals(HTTP_METHOD_POST_METHOD)) {
                    httpURLConnection.setDoOutput(true);
                    writer = new PrintWriter(httpURLConnection.getOutputStream());
                    writer.print(queryStringForPOSTMethod);
                    writer.close();
                } else {
                    httpURLConnection.setRequestMethod(HTTP_METHOD_GET_METHOD);
                }
            }
            is = httpURLConnection.getInputStream();
            isr = new InputStreamReader(is, encoding);
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (ProtocolException e) {
            throw new JaxyClientNetworkException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new JaxyClientNetworkException(e);
        }
        catch (UnknownHostException e) {
            throw new JaxyClientNetworkException(e);
        }
        catch (IOException e) {
            InputStreamReader isr2 = null;
            InputStream errorStream = null;
            BufferedReader br2 = null;
            try {
                errorStream = httpURLConnection.getErrorStream();
                isr2 = new InputStreamReader(errorStream, encoding);
                br2 = new BufferedReader(isr2);
                String line = null;
                while ((line = br2.readLine()) != null) {
                    sb.append(line);
                }
                String string = e.getMessage();
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                if (br2 != null) {
                    try {
                        br2.close();
                    }
                    catch (IOException e2) {
                        e.printStackTrace();
                    }
                }
                if (isr2 != null) {
                    try {
                        isr2.close();
                    }
                    catch (IOException e2) {
                        e.printStackTrace();
                    }
                }
                if (errorStream != null) {
                    try {
                        errorStream.close();
                    }
                    catch (IOException e2) {
                        e.printStackTrace();
                    }
                }
            }
            throw new JaxyClientNetworkException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            httpURLConnection.disconnect();
        }
        return sb.toString();
    }

    private void setHeaderPropertiesToHttpUrlConnection(HttpURLConnection httpURLConnection) {
        if (this.mRequestPropertyMap != null) {
            Set<String> headerNamesSet = this.mRequestPropertyMap.keySet();
            for (String headerName : headerNamesSet) {
                List<String> headerValueList = this.mRequestPropertyMap.get(headerName);
                for (String headervalue : headerValueList) {
                    httpURLConnection.addRequestProperty(headerName, headervalue);
                }
            }
        }
    }

    private void initHTTPS() {
        KeyManager[] km = null;
        TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                for (X509Certificate cert : chain) {
                    Principal principal = cert.getIssuerDN();
                }
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sslcontext = SSLContext.getInstance(this.mSslAlgorithm);
            sslcontext.init(km, tm, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public String doHttpRequest() throws JaxyClientNetworkException {
        String responseText = "";
        String queryParamString = this.getQueryParamString();
        String requestUrl = null;
        if (queryParamString.length() > 0) {
            queryParamString = queryParamString.substring(0, queryParamString.length() - 1);
            requestUrl = this.mEndpointUrl + "?" + queryParamString;
        } else {
            requestUrl = this.mEndpointUrl;
        }
        this.mLatestRequestUrl = requestUrl;
        if (requestUrl.startsWith(SUFFIX_HTTP)) {
            responseText = this.doHttpRequest(requestUrl);
        } else if (requestUrl.startsWith(SUFFIX_HTTPS)) {
            responseText = this.doHttpsRequest(requestUrl);
        }
        return responseText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doHttpRequest(String requestUrl) throws JaxyClientNetworkException {
        String proxyHost = this.mProxyHost;
        String proxyPort = this.mProxyPort;
        String encoding = this.mEncoding;
        if (this.mIsUseBasicAuth) {
            Authenticator.setDefault(new BasicAuthAuthenticator(this.mBasicAuthUserName, this.mBasicAuthUsePassword));
        }
        int iProxyPort = Integer.parseInt(proxyPort);
        HttpURLConnection httpURLConnection = null;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer("");
        try {
            PrintWriter writer;
            JaxyClientURLWrapper conn;
            String urlPart;
            String[] requestUrlSplit;
            String queryStringForPOSTMethod;
            if (proxyHost == null) {
                queryStringForPOSTMethod = "";
                if (this.mHttpRequestMethod.equals(HTTP_METHOD_POST_METHOD) && (requestUrlSplit = requestUrl.split("\\?")).length == 2) {
                    requestUrl = urlPart = requestUrlSplit[0];
                    queryStringForPOSTMethod = requestUrlSplit[1];
                }
                conn = new JaxyClientURLWrapper(requestUrl);
                httpURLConnection = (HttpURLConnection)conn.openConnectionNoProxy();
                httpURLConnection.setConnectTimeout(this.mTimeoutMillis);
                httpURLConnection.setReadTimeout(this.mTimeoutMillis);
                this.setHeaderPropertiesToHttpUrlConnection(httpURLConnection);
                if (this.mHttpRequestMethod.equals(HTTP_METHOD_POST_METHOD)) {
                    httpURLConnection.setDoOutput(true);
                    writer = new PrintWriter(httpURLConnection.getOutputStream());
                    writer.print(queryStringForPOSTMethod);
                    writer.close();
                } else {
                    httpURLConnection.setRequestMethod(HTTP_METHOD_GET_METHOD);
                }
            } else {
                queryStringForPOSTMethod = "";
                if (this.mHttpRequestMethod.equals(HTTP_METHOD_POST_METHOD) && (requestUrlSplit = requestUrl.split("\\?")).length == 2) {
                    requestUrl = urlPart = requestUrlSplit[0];
                    queryStringForPOSTMethod = requestUrlSplit[1];
                }
                conn = new JaxyClientURLWrapper(requestUrl);
                httpURLConnection = (HttpURLConnection)conn.openConnectionWithProxy(proxyHost, iProxyPort);
                httpURLConnection.setConnectTimeout(this.mTimeoutMillis);
                httpURLConnection.setReadTimeout(this.mTimeoutMillis);
                this.setHeaderPropertiesToHttpUrlConnection(httpURLConnection);
                if (this.mHttpRequestMethod.equals(HTTP_METHOD_POST_METHOD)) {
                    httpURLConnection.setDoOutput(true);
                    writer = new PrintWriter(httpURLConnection.getOutputStream());
                    writer.print(queryStringForPOSTMethod);
                    writer.close();
                } else {
                    httpURLConnection.setRequestMethod(HTTP_METHOD_GET_METHOD);
                }
            }
            is = httpURLConnection.getInputStream();
            isr = new InputStreamReader(is, encoding);
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (ProtocolException e) {
            throw new JaxyClientNetworkException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new JaxyClientNetworkException(e);
        }
        catch (IOException serverSideException) {
            BufferedReader br2 = null;
            InputStreamReader isr2 = null;
            InputStream errorStream = null;
            try {
                errorStream = httpURLConnection.getErrorStream();
                if (errorStream != null) {
                    isr2 = new InputStreamReader(errorStream, encoding);
                    br2 = new BufferedReader(isr2);
                    String line = null;
                    while ((line = br2.readLine()) != null) {
                        sb.append(line);
                    }
                    String string = serverSideException.getMessage();
                }
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                if (br2 != null) {
                    try {
                        br2.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (isr2 != null) {
                    try {
                        isr2.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (errorStream != null) {
                    try {
                        errorStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            throw new JaxyClientNetworkException(serverSideException);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            httpURLConnection.disconnect();
        }
        return sb.toString();
    }

    public String getLatestRequestRawUrl() {
        String requestUrl = null;
        try {
            Set<String> keyset = this.mParameterMap.keySet();
            Iterator<String> iterator = keyset.iterator();
            StringBuffer queryParamSB = new StringBuffer();
            while (iterator.hasNext()) {
                String objKey = iterator.next();
                String[] objValues = this.mParameterMap.get(objKey);
                if (objValues == null || objValues.length <= 0) continue;
                for (int i = 0; i < objValues.length; ++i) {
                    queryParamSB.append(objKey);
                    queryParamSB.append("=");
                    if (this.mNeedNotEncodeParameterNameSet.contains(objKey)) {
                        queryParamSB.append(objValues[i]);
                    } else {
                        queryParamSB.append(URLEncoder.encode(objValues[i], this.mEncoding));
                    }
                    queryParamSB.append("&");
                }
            }
            String queryParamString = queryParamSB.toString();
            if (queryParamString.length() > 0) {
                queryParamString = queryParamString.substring(0, queryParamString.length() - 1);
                requestUrl = this.mEndpointUrl + "?" + queryParamString;
            } else {
                requestUrl = this.mEndpointUrl;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return requestUrl;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String encoding) {
        this.mEncoding = encoding;
    }

    public String getProxyHost() {
        return this.mProxyHost;
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.mProxyHost = proxyHost;
        this.mProxyPort = String.valueOf(proxyPort);
    }

    public String getEndpointUrl() {
        return this.mEndpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.mEndpointUrl = endpointUrl;
    }

    public void setUseCDATA(boolean useCDATA) {
        this.mIsUseCDATA = useCDATA;
        this.xmlNodeTransform.setUseCDATA(useCDATA);
    }

    public String getQueryParamString() {
        Set<String> keyset = this.mParameterMap.keySet();
        Iterator<String> iterator = keyset.iterator();
        StringBuffer queryParamSB = new StringBuffer();
        while (iterator.hasNext()) {
            String srcObjKey = iterator.next();
            String[] objValues = this.mParameterMap.get(srcObjKey);
            boolean isThisObjKeyNeedforceIndexed = this.mForceIndexedParameterNameSet.contains(srcObjKey);
            if (objValues == null || objValues.length <= 0) continue;
            for (int idx = 0; idx < objValues.length; ++idx) {
                String objKey = srcObjKey;
                int NEED_BRACKET_MINIMUM_INDEX = 2;
                if (objValues.length >= 2 || isThisObjKeyNeedforceIndexed) {
                    objKey = srcObjKey + "[" + idx + "]";
                }
                try {
                    String encodedKey = URLEncoder.encode(objKey, this.mEncoding);
                    queryParamSB.append(encodedKey);
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                queryParamSB.append("=");
                if (this.mNeedNotEncodeParameterNameSet.contains(srcObjKey)) {
                    queryParamSB.append(objValues[idx]);
                } else {
                    try {
                        String encodedValue = URLEncoder.encode(objValues[idx], this.mEncoding);
                        queryParamSB.append(encodedValue);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                queryParamSB.append("&");
            }
        }
        String queryParamString = queryParamSB.toString();
        return queryParamString;
    }

    public String getLatestRequestUrl() {
        return this.mLatestRequestUrl;
    }

    public SourceCodeGenerator gen() {
        if (this.mSourceCodeGenerator == null) {
            this.mSourceCodeGenerator = new SourceCodeGenerator();
        }
        return this.mSourceCodeGenerator;
    }

    class SourceGenTrigger {
        public SourceGenTriggerMethod triggerMethod = SourceGenTriggerMethod.UNKNOWN;
        public String httpMethod;
        public String endpointUrl = "";
        public boolean useProxy = false;
        public String proxyHost;
        public int proxyPort;
        public boolean useCDATA = false;
        public boolean useBasicAuth = false;
        public String basicAuthUser;
        public String basicAuthPassword;
        public Map<String, String[]> parameterMap;
        public File file;
        public String text;

        SourceGenTrigger() {
        }

        public void clear() {
            this.triggerMethod = SourceGenTriggerMethod.UNKNOWN;
            this.httpMethod = null;
            this.endpointUrl = "";
            this.parameterMap = null;
            this.useProxy = false;
            this.proxyHost = null;
            this.proxyPort = 0;
            this.basicAuthUser = null;
            this.basicAuthPassword = null;
            this.useCDATA = false;
            this.file = null;
            this.text = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SourceGenTriggerMethod {
        FROM_NET,
        FROM_FILE,
        FROM_TEXT,
        UNKNOWN;

    }

    public class SourceCodeGenerator {
        private String mSrcCodePackageName = "";
        private String mSrcCodeClassNamePrefix = "";

        public SourceCodeGenerator setPackageName(String srcCodePackageName) {
            this.mSrcCodePackageName = srcCodePackageName;
            return this;
        }

        public SourceCodeGenerator setClassNamePrefix(String srcCodeClassNamePrefix) {
            this.mSrcCodeClassNamePrefix = srcCodeClassNamePrefix;
            return this;
        }

        public void generateParserCodeTo(JsonNode node, File dir) {
            this.getJsonGen(node).generateParserCodeTo(dir);
        }

        public void generateParserCodeToConsole(JsonNode node) {
            this.getJsonGen(node).generateParserCodeToConsole();
        }

        public void generateParserCodeTo(JsonNode node, StringBuilder sb) {
            this.getJsonGen(node).generateParserCodeTo(sb);
        }

        private JaxySrcGen4JsonNode getJsonGen(JsonNode node) {
            if (node == null) {
                throw new RuntimeException("Node is null.");
            }
            JaxySrcGen4JsonNode jsonGen = new JaxySrcGen4JsonNode(node);
            jsonGen.setSourceGenTrigger(JaxyClient.this.mSourceGenTrigger);
            jsonGen.setSrcCodeClassNamePrefix(this.mSrcCodeClassNamePrefix);
            jsonGen.setSrcCodePackageName(this.mSrcCodePackageName);
            return jsonGen;
        }

        public void generateParserCodeTo(XmlNode node, File dir) {
            this.getXmlGen(node).generateParserCodeTo(dir);
        }

        public void generateParserCodeToConsole(XmlNode node) {
            this.getXmlGen(node).generateParserCodeToConsole();
        }

        public void generateParserCodeTo(XmlNode node, StringBuilder sb) {
            this.getXmlGen(node).generateParserCodeTo(sb);
        }

        private JaxySrcGen4XmlNode getXmlGen(XmlNode node) {
            if (node == null) {
                throw new RuntimeException("Node is null.");
            }
            JaxySrcGen4XmlNode xmlGen = new JaxySrcGen4XmlNode(node);
            xmlGen.setSourceGenTrigger(JaxyClient.this.mSourceGenTrigger);
            xmlGen.setSrcCodeClassNamePrefix(this.mSrcCodeClassNamePrefix);
            xmlGen.setSrcCodePackageName(this.mSrcCodePackageName);
            return xmlGen;
        }
    }

    static final class JaxyClientURLWrapper {
        private URL _url;

        public JaxyClientURLWrapper(String requsetUrl) {
            try {
                this._url = new URL(requsetUrl);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }

        public URLConnection openConnectionNoProxy() {
            URLConnection conn = null;
            try {
                conn = this._url.openConnection();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return conn;
        }

        public URLConnection openConnectionWithProxy(String proxyHost, int proxyPort) {
            URLConnection conn = null;
            try {
                InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                conn = this._url.openConnection(proxy);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return conn;
        }
    }

    static final class BasicAuthAuthenticator
    extends Authenticator {
        private String mUsername;
        private String mPassword;

        public BasicAuthAuthenticator() {
        }

        public BasicAuthAuthenticator(String username, String password) {
            this.mUsername = username;
            this.mPassword = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.mUsername, this.mPassword.toCharArray());
        }

        public String getAuthRealm() {
            return super.getRequestingPrompt();
        }

        public String getUsername() {
            return this.mUsername;
        }

        public void setUsername(String username) {
            this.mUsername = username;
        }

        public String getPassword() {
            return this.mPassword;
        }

        public void setPassword(String password) {
            this.mPassword = password;
        }
    }
}

