/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jaxy;

import org.json.JSONException;
import org.json.JSONObject;
import org.riversun.jaxy.JaxyJsonNodeParser;
import org.riversun.jaxy.JsonNode;

class JaxyConvJsonFromText {
    private final JaxyJsonNodeParser mJaxyParser = new JaxyJsonNodeParser();

    JaxyConvJsonFromText() {
    }

    public JsonNode toJsonNode(String jsonText) {
        JsonObjectWrapper jsonObjEx = this.toJsonNodeInternally(jsonText);
        JsonNode jsonNode = this.mJaxyParser.buildJsonNode(jsonObjEx.jsonObj);
        jsonNode.setHasNoSingleParent(jsonObjEx.hasNoSingleParent);
        return jsonNode;
    }

    private JsonObjectWrapper toJsonNodeInternally(String jsonText) {
        boolean hasNoSingleParent;
        JSONObject jsonObj = this.toJsonObject(jsonText);
        int jsonChildrenCount = jsonObj.length();
        if (jsonChildrenCount > 1) {
            jsonText = "{\"json_parent\":" + jsonText + "}";
            jsonObj = this.toJsonObject(jsonText);
            hasNoSingleParent = true;
        } else {
            hasNoSingleParent = false;
        }
        return new JsonObjectWrapper(jsonObj, hasNoSingleParent);
    }

    private JSONObject toJsonObject(String jsonText) {
        JSONObject jsonObj;
        try {
            jsonObj = new JSONObject(jsonText);
        }
        catch (JSONException e) {
            e.printStackTrace();
            jsonObj = new JSONObject();
        }
        return jsonObj;
    }

    private static class JsonObjectWrapper {
        JSONObject jsonObj;
        boolean hasNoSingleParent = false;

        public JsonObjectWrapper(JSONObject jsonObj, boolean hasNoSingleParent) {
            this.jsonObj = jsonObj;
            this.hasNoSingleParent = hasNoSingleParent;
        }
    }
}

