/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jaxy;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.riversun.jaxy.JsonNode;

class JaxyJsonNodeParser {
    JaxyJsonNodeParser() {
    }

    public JsonNode buildJsonNode(JSONObject jsonObject) {
        JsonNode resultNode = new JsonNode();
        try {
            this.parse(jsonObject, resultNode);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return resultNode;
    }

    public void printHints(JSONObject jsonObject) {
        JsonNode resultNode = new JsonNode();
        try {
            StringBuffer sb = new StringBuffer();
            this.showAllParamsValues(jsonObject, resultNode, 0, "", sb);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void parse(Object parent, JsonNode parentNode) throws JSONException {
        if (parent instanceof JSONObject) {
            JSONObject parentJSONObject = (JSONObject)parent;
            Iterator itor = parentJSONObject.keys();
            while (itor.hasNext()) {
                String key = (String)itor.next();
                JsonNode childNode = new JsonNode();
                childNode.elementName = key;
                Object childObj = parentJSONObject.get(key);
                if (!(childObj instanceof JSONObject) && !(childObj instanceof JSONArray)) {
                    childNode.elementText = String.valueOf(childObj);
                    parentNode.addChildNode(key, childNode);
                    continue;
                }
                if (childObj instanceof JSONObject) {
                    parentNode.addChildNode(key, childNode);
                    this.parse(childObj, childNode);
                    continue;
                }
                if (!(childObj instanceof JSONArray)) continue;
                parentNode.addChildNode(key, childNode);
                this.parse(childObj, childNode);
            }
        } else if (parent instanceof JSONArray) {
            JSONArray parentJSONArray = (JSONArray)parent;
            int leng = parentJSONArray.length();
            for (int i = 0; i < leng; ++i) {
                Object childObj = parentJSONArray.get(i);
                JsonNode childNode = new JsonNode();
                childNode.elementName = parentNode.elementName;
                parentNode.mParenNode.addChildNode(childNode.elementName, childNode);
                this.parse(childObj, childNode);
            }
            JsonNode grandParentNode = parentNode.mParenNode;
            String key = parentNode.elementName;
            grandParentNode.removeFirstChildNode(key, parentNode);
        }
    }

    private void showAllParamsValues(Object parent, JsonNode parentNode, int level, String line, StringBuffer buffer) throws JSONException {
        if (parent instanceof JSONObject) {
            JSONObject parentJSONObject = (JSONObject)parent;
            Iterator itor = parentJSONObject.keys();
            while (itor.hasNext()) {
                String key = (String)itor.next();
                JsonNode childNode = new JsonNode();
                childNode.elementName = key;
                Object childObj = parentJSONObject.get(key);
                if (!(childObj instanceof JSONObject) && !(childObj instanceof JSONArray)) {
                    parentNode.addChildNode(key, childNode);
                    childNode.elementText = String.valueOf(childObj);
                    buffer.append(line + "._(" + "\"" + key + "\"" + ")=" + "\"" + childNode.elementText + "\"");
                    buffer.append("\r\n");
                    continue;
                }
                if (childObj instanceof JSONObject) {
                    parentNode.addChildNode(key, childNode);
                    this.showAllParamsValues(childObj, childNode, level + 1, line + "._(" + "\"" + key + "\"" + ")", buffer);
                    continue;
                }
                if (!(childObj instanceof JSONArray)) continue;
                parentNode.addChildNode(key, childNode);
                this.showAllParamsValues(childObj, childNode, level + 1, line, buffer);
            }
        } else if (parent instanceof JSONArray) {
            JSONArray parentJSONArray = (JSONArray)parent;
            int leng = parentJSONArray.length();
            for (int i = 0; i < leng; ++i) {
                Object childObj = parentJSONArray.get(i);
                JsonNode childNode = new JsonNode();
                childNode.elementName = parentNode.elementName;
                parentNode.mParenNode.addChildNode(childNode.elementName, childNode);
                this.showAllParamsValues(childObj, childNode, level + 1, line + ".__(" + "\"" + parentNode.elementName + "\"" + ")[" + String.valueOf(i) + "]", buffer);
            }
            JsonNode grandParentNode = parentNode.mParenNode;
            String key = parentNode.elementName;
            grandParentNode.removeFirstChildNode(key, parentNode);
        }
    }
}

