/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jaxy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.riversun.jaxy.JaxyClient;
import org.riversun.jaxy.JaxyNode;
import org.riversun.jaxy.JaxySrcGenSourceCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JaxySrcGenBase<T extends JaxyNode> {
    Map<String, JaxySrcGenSourceCode> mModelClassSourceCodeList = null;
    JaxySrcGenSourceCode mParserMainClassSourceCode;
    protected T mTargetNode;
    private String mSrcCodePackageName = "";
    private String mSrcCodeClassNamePrefix = "";
    protected JaxyClient.SourceGenTrigger mSourceGenTrigger;

    public void setSourceGenTrigger(JaxyClient.SourceGenTrigger sourceGenTrigger) {
        this.mSourceGenTrigger = sourceGenTrigger;
    }

    public JaxySrcGenBase(T targetNode) {
        this.mTargetNode = targetNode;
    }

    protected abstract void buildSourceCodeClasses(T var1, boolean var2, JaxySrcGenSourceCode var3);

    public final void generateParserCodeTo(File dir) {
        this.mModelClassSourceCodeList = new LinkedHashMap<String, JaxySrcGenSourceCode>();
        this.buildSourceCodeClasses(null, false, null);
        String filePath = dir.getAbsolutePath();
        this.saveSourceCodeToFile(filePath + File.separator + this.mParserMainClassSourceCode.getClassName() + ".java", this.mParserMainClassSourceCode.getString(), "UTF-8");
        for (JaxySrcGenSourceCode cff : this.mModelClassSourceCodeList.values()) {
            this.saveSourceCodeToFile(filePath + File.separator + cff.getClassName() + ".java", cff.getString(), "UTF-8");
        }
    }

    public final void generateParserCodeToConsole() {
        this.mModelClassSourceCodeList = new LinkedHashMap<String, JaxySrcGenSourceCode>();
        StringBuilder sb = new StringBuilder();
        this.generateParserCodeTo(sb);
        System.out.println(sb.toString());
    }

    public final void generateParserCodeTo(StringBuilder sb) {
        this.mModelClassSourceCodeList = new LinkedHashMap<String, JaxySrcGenSourceCode>();
        this.buildSourceCodeClasses(null, false, null);
        sb.append("\n");
        sb.append(this.mParserMainClassSourceCode.getString());
        sb.append("\n");
        sb.append("\n");
        for (JaxySrcGenSourceCode cff : this.mModelClassSourceCodeList.values()) {
            sb.append(cff.getString());
            sb.append("\n");
            sb.append("\n");
        }
    }

    protected String getColonSeparatedString(String str) {
        return str.replaceAll(":", "_");
    }

    protected String getPrefixAddedInitialClassNameString(String str) {
        String firstString = str.substring(0, 1).toUpperCase();
        String restingString = str.substring(1, str.length());
        return this.getSrcCodeClassNamePrefix() + firstString + restingString;
    }

    protected boolean isStartedWithInt(String str) {
        boolean ret = true;
        try {
            String firstChar = str.substring(0, 1);
            Integer.parseInt(firstChar);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected void saveSourceCodeToFile(String fileName, String fileContent, String encoding) {
        File f = new File(fileName);
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(f);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, encoding));
            bw.write(fileContent);
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        return str.equals("");
    }

    public boolean isNotBlank(String str) {
        return str != null && !str.equals("");
    }

    public String getSrcCodePackageName() {
        return this.mSrcCodePackageName;
    }

    public void setSrcCodePackageName(String srcCodePackageName) {
        this.mSrcCodePackageName = srcCodePackageName;
    }

    public String getSrcCodeClassNamePrefix() {
        return this.mSrcCodeClassNamePrefix;
    }

    public void setSrcCodeClassNamePrefix(String srcCodeClassNamePrefix) {
        this.mSrcCodeClassNamePrefix = srcCodeClassNamePrefix;
    }
}

