/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jaxy;

import java.util.Set;
import org.riversun.jaxy.JaxyClient;

class JaxyClientTriggerCodeGen {
    private TriggerType mTriggerType;
    private JaxyClient.SourceGenTrigger mSourceGenTrigger;

    public JaxyClientTriggerCodeGen(TriggerType triggerType, JaxyClient.SourceGenTrigger sourceGenTrigger) {
        this.mTriggerType = triggerType;
        this.mSourceGenTrigger = sourceGenTrigger;
    }

    String generate() {
        if (TriggerType.JSON == this.mTriggerType) {
            switch (this.mSourceGenTrigger.triggerMethod) {
                case FROM_NET: {
                    return this.generateJsonTriggerForNet();
                }
                case FROM_FILE: {
                    return this.generateJsonTriggerForFile();
                }
                case FROM_TEXT: {
                    return this.generateJsonTriggerForText();
                }
            }
            throw new RuntimeException("Please set triggerMethod.");
        }
        if (TriggerType.XML == this.mTriggerType) {
            switch (this.mSourceGenTrigger.triggerMethod) {
                case FROM_NET: {
                    return this.generateXmlTriggerForNet();
                }
                case FROM_TEXT: {
                    return this.generateXmlTriggerForText();
                }
                case FROM_FILE: {
                    return this.generateXmlTriggerForFile();
                }
            }
            throw new RuntimeException("Please set triggerMethod.");
        }
        throw new RuntimeException("Please set triggerType.");
    }

    private String generateJsonTriggerForNet() {
        StringBuilder sb = new StringBuilder();
        this.generateCommonNetworkBasedTriggerCode(sb);
        sb.append("JsonNode node=jaxy.getJson();");
        sb.append("\n");
        return sb.toString();
    }

    private String generateJsonTriggerForText() {
        return "UNDER CONSTRUCTION";
    }

    private String generateJsonTriggerForFile() {
        return "UNDER CONSTRUCTION";
    }

    private String generateXmlTriggerForNet() {
        StringBuilder sb = new StringBuilder();
        this.generateCommonNetworkBasedTriggerCode(sb);
        sb.append("XmlNode node=jaxy.getXml();");
        sb.append("\n");
        return sb.toString();
    }

    private String generateXmlTriggerForText() {
        return "UNDER CONSTRUCTION";
    }

    private String generateXmlTriggerForFile() {
        return "UNDER CONSTRUCTION";
    }

    private void generateCommonNetworkBasedTriggerCode(StringBuilder sb) {
        String DQ = "\"";
        sb.append("JaxyClient jaxy = new JaxyClient();");
        sb.append("\n");
        sb.append("jaxy.setEndpointUrl(");
        sb.append("\"" + this.mSourceGenTrigger.endpointUrl + "\"");
        sb.append(");");
        sb.append("\n");
        sb.append("jaxy.setHttpMethod(");
        sb.append("\"" + this.mSourceGenTrigger.httpMethod + "\"");
        sb.append(");");
        sb.append("\n");
        if (this.mSourceGenTrigger.parameterMap != null && this.mSourceGenTrigger.parameterMap.size() > 0) {
            Set<String> keySet = this.mSourceGenTrigger.parameterMap.keySet();
            for (String key : keySet) {
                String[] paramValues;
                for (String paramValue : paramValues = this.mSourceGenTrigger.parameterMap.get(key)) {
                    sb.append("jaxy.addParameter(");
                    sb.append("\"" + key + "\"" + "," + "\"" + paramValue + "\"");
                    sb.append(");");
                    sb.append("\n");
                }
            }
        }
        sb.append("jaxy.setUseCDATA(");
        sb.append(this.mSourceGenTrigger.useCDATA);
        sb.append(");");
        sb.append("\n");
        if (this.mSourceGenTrigger.useProxy) {
            sb.append("jaxy.setProxy(");
            sb.append("\"" + this.mSourceGenTrigger.proxyHost + "\"" + "," + this.mSourceGenTrigger.proxyPort);
            sb.append(");");
            sb.append("\n");
        }
        if (this.mSourceGenTrigger.useBasicAuth) {
            sb.append("jaxy.setUseBasicAuth(true);");
            sb.append("\n");
            sb.append("jaxy.setBasicAuthUserNameAndPassword(");
            sb.append("\"" + this.mSourceGenTrigger.basicAuthUser + "\"" + "," + "\"" + this.mSourceGenTrigger.basicAuthPassword + "\"");
            sb.append(");");
            sb.append("\n");
        } else {
            sb.append("jaxy.setUseBasicAuth(false);");
            sb.append("\n");
            sb.append("jaxy.setBasicAuthUserNameAndPassword(null,null);");
            sb.append("\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TriggerType {
        JSON,
        XML;

    }
}

