/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jaxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.riversun.jaxy.JaxyDef;
import org.riversun.jaxy.XmlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class JaxyConvXmlFromText {
    private boolean mEnableAttributeOnlyElement = true;
    private boolean mIsUseCDATA;

    JaxyConvXmlFromText() {
    }

    public XmlNode toXmlNode(String xmlString) {
        Document xmlDocument = this.getDocumentFromString(xmlString);
        return this.toXmlNode(xmlDocument);
    }

    public XmlNode toXmlNode(File xmlFile) {
        Document xmlDocument = this.getDocumentFromFile(xmlFile);
        return this.toXmlNode(xmlDocument);
    }

    public XmlNode toXmlNode(Document xmlDocument) {
        XmlNode xmlNode = new XmlNode();
        if (xmlDocument != null) {
            Element rootNode = xmlDocument.getDocumentElement();
            this.searchNodes(rootNode, null, xmlNode, null);
        } else {
            xmlNode = null;
        }
        return xmlNode;
    }

    private void searchNodes(Node parentNode, Node grandParentNode, XmlNode parentXmlElement, XmlNode grandParentXmlElement) {
        if (parentNode.hasChildNodes() || parentNode.hasAttributes()) {
            XmlNode currentElement = new XmlNode();
            currentElement.elementName = parentNode.getNodeName();
            NamedNodeMap attrs = parentNode.getAttributes();
            int attrLeng = attrs.getLength();
            if (attrLeng > 0) {
                if (this.mEnableAttributeOnlyElement && !parentNode.hasChildNodes()) {
                    Document document = parentNode.getOwnerDocument();
                    parentNode.appendChild(document.createTextNode(JaxyDef.HAVING_ATTRIBUTE_SIGN));
                }
                for (int i = 0; i < attrLeng; ++i) {
                    Node node = attrs.item(i);
                    currentElement.addAttribute(node.getNodeName(), node.getNodeValue());
                }
            }
            if (this.hasChildElementNodes(parentNode)) {
                parentXmlElement.addChildXmlElement(parentNode.getNodeName(), currentElement);
            }
            NodeList nodeList = parentNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                this.searchNodes(node, parentNode, currentElement, parentXmlElement);
            }
        } else if (parentNode.getNodeType() == 3) {
            String plainedNodeValue = parentNode.getNodeValue();
            char charCR = '\r';
            char charLF = '\n';
            char charTab = '\t';
            String strCR = String.valueOf(charCR);
            String strLF = String.valueOf(charLF);
            String strTAB = String.valueOf(charTab);
            String spaceDeletedNodeValue = plainedNodeValue.replace(" ", "");
            String lfDeletedNodeValue = spaceDeletedNodeValue.replace(strLF, "");
            String crDeletedNodeValue = lfDeletedNodeValue.replace(strCR, "");
            String tabDeletedNodeValue = crDeletedNodeValue.replace(strTAB, "");
            String allDeletedNodeValue = tabDeletedNodeValue;
            int nodeValueLength = allDeletedNodeValue.length();
            if (nodeValueLength > 0) {
                parentXmlElement.elementText = parentNode.getNodeValue();
                if (this.mEnableAttributeOnlyElement && parentXmlElement.elementText.equals(JaxyDef.HAVING_ATTRIBUTE_SIGN)) {
                    parentXmlElement.elementText = "";
                }
                grandParentXmlElement.addChildXmlElement(grandParentNode.getNodeName(), parentXmlElement);
            }
        }
    }

    public void setEnableAttributeOnlyElement(boolean enableAttributeOnlyElement) {
        this.mEnableAttributeOnlyElement = enableAttributeOnlyElement;
    }

    public void setUseCDATA(boolean useCDATA) {
        this.mIsUseCDATA = useCDATA;
    }

    private boolean hasChildElementNodes(Node targetNode) {
        boolean retValue = false;
        for (int i = 0; i < targetNode.getChildNodes().getLength(); ++i) {
            Node node = targetNode.getChildNodes().item(i);
            if (node.getNodeType() != 1) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    private Document getDocumentFromString(String str) {
        Document doc = null;
        try {
            DocumentBuilderFactory docbuilderFactory = DocumentBuilderFactory.newInstance();
            docbuilderFactory.setCoalescing(this.mIsUseCDATA);
            DocumentBuilder docBuilder = docbuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(new StringReader(str)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    private Document getDocumentFromFile(File file) {
        Document doc = null;
        try {
            DocumentBuilderFactory docbuilderFactory = DocumentBuilderFactory.newInstance();
            docbuilderFactory.setCoalescing(this.mIsUseCDATA);
            DocumentBuilder docBuilder = docbuilderFactory.newDocumentBuilder();
            FileInputStream inStream = new FileInputStream(file);
            doc = docBuilder.parse(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }
}

