/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jaxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.riversun.jaxy.JaxyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlNode
extends JaxyNode {
    private Map<String, List<XmlNode>> mLocalDataMap = new LinkedHashMap<String, List<XmlNode>>();
    private Map<String, List<String>> mLocalAttrMap = new HashMap<String, List<String>>();

    public XmlNode child(String key) {
        ArrayList list = (ArrayList)this.mLocalDataMap.get(key);
        XmlNode retVal = null;
        if (list != null) {
            XmlNode[] xmlElementArray = list.toArray(new XmlNode[0]);
            retVal = xmlElementArray[0];
        } else {
            retVal = new XmlNode();
        }
        return retVal;
    }

    public XmlNode[] children(String key) {
        List<XmlNode> list = this.mLocalDataMap.get(key);
        XmlNode[] retVal = null;
        if (list != null) {
            XmlNode[] xmlElementArray = list.toArray(new XmlNode[0]);
            retVal = xmlElementArray;
        } else {
            retVal = new XmlNode[]{};
        }
        return retVal;
    }

    public String[] getChildElementNames() {
        Set<String> childElementNameSet = this.mLocalDataMap.keySet();
        String[] retVal = childElementNameSet.toArray(new String[0]);
        return retVal;
    }

    public String toString() {
        return this.elementText;
    }

    public String attr(String attributeName) {
        String retValue = null;
        ArrayList attrElementList = (ArrayList)this.mLocalAttrMap.get(attributeName);
        retValue = attrElementList == null ? null : (String)attrElementList.get(0);
        return retValue;
    }

    public String[] attrValues(String attributeName) {
        String[] retValue = null;
        ArrayList attrElementList = (ArrayList)this.mLocalAttrMap.get(attributeName);
        retValue = attrElementList == null ? new String[]{} : attrElementList.toArray(new String[0]);
        return retValue;
    }

    public void addChildXmlElement(String key, XmlNode xmlElement) {
        List<XmlNode> xmlElementList = this.mLocalDataMap.get(key);
        if (xmlElementList == null) {
            xmlElementList = new ArrayList<XmlNode>();
            this.mLocalDataMap.put(key, xmlElementList);
        }
        xmlElementList.add(xmlElement);
    }

    public void addAttribute(String key, String value) {
        ArrayList<String> attrElementList = (ArrayList<String>)this.mLocalAttrMap.get(key);
        if (attrElementList == null) {
            attrElementList = new ArrayList<String>();
            this.mLocalAttrMap.put(key, attrElementList);
        }
        attrElementList.add(value);
    }

    public String stringValue() {
        return this.elementText;
    }

    public int intValue() {
        return Integer.parseInt(this.elementText);
    }

    public long longValue() {
        return Long.parseLong(this.elementText);
    }

    public float floatValue() {
        return Float.parseFloat(this.elementText);
    }

    public double doubleValue() {
        return Double.parseDouble(this.elementText);
    }

    public Map<String, List<String>> getLocalAttrMap() {
        return this.mLocalAttrMap;
    }
}

