/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jetty.basicauth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.riversun.jetty.basicauth.BasicAuth;

public class BasicAuthResourceHandler
extends ResourceHandler {
    private BasicAuth mBasicAuthCondition;
    private Map<String, List<BasicAuth.UserPath>> mPathSpecUserMap = new LinkedHashMap<String, List<BasicAuth.UserPath>>();

    public BasicAuthResourceHandler setBasicAuth(BasicAuth basicAuth) {
        this.mBasicAuthCondition = basicAuth;
        List<BasicAuth.UserPath> userPathList = basicAuth.getUserPathList();
        for (BasicAuth.UserPath userPath : userPathList) {
            String[] pathSpecs;
            for (String pathSpec : pathSpecs = userPath.pathSpecs.split(",")) {
                List<BasicAuth.UserPath> storedUserPathList = this.mPathSpecUserMap.get(pathSpec);
                if (storedUserPathList == null) {
                    storedUserPathList = new ArrayList<BasicAuth.UserPath>();
                    this.mPathSpecUserMap.put(pathSpec, storedUserPathList);
                }
                storedUserPathList.add(userPath);
            }
        }
        return this;
    }

    private List<BasicAuth.UserPath> isBasicAuthNeeded(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        Set<String> pathSpecSet = this.mPathSpecUserMap.keySet();
        for (String pathSpec : pathSpecSet) {
            String path;
            int asterPos = pathSpec.indexOf("*");
            if (!(asterPos >= 0 ? pathInfo.startsWith(path = pathSpec.substring(0, asterPos)) : pathInfo.equals(path = pathSpec))) continue;
            return this.mPathSpecUserMap.get(pathSpec);
        }
        return null;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String authHeader = req.getHeader("Authorization");
        List<BasicAuth.UserPath> permitUserList = this.isBasicAuthNeeded(req);
        if (permitUserList != null) {
            if (authHeader != null && authHeader.startsWith("Basic ")) {
                String base64encodedUserColonPassPart = authHeader.substring(authHeader.indexOf(" ") + 1);
                _User user = this.parseAuthUserFromBase64(base64encodedUserColonPassPart);
                boolean isAuthenticated = false;
                for (BasicAuth.UserPath allowedUser : permitUserList) {
                    if (!allowedUser.userName.equals(user.userName) || !allowedUser.password.equals(user.password)) continue;
                    isAuthenticated = true;
                    break;
                }
                if (isAuthenticated) {
                    super.handle(target, baseRequest, req, resp);
                    return;
                }
                boolean retryWhenAnotherUserNeeded = true;
                if (retryWhenAnotherUserNeeded) {
                    String realm = this.mBasicAuthCondition.getRealm();
                    resp.setHeader("WWW-Authenticate", "BASIC realm=\"" + realm + "\"");
                    resp.sendError(401, "Authorization Required");
                } else {
                    resp.sendError(403, "You don't have permission to access.");
                }
                return;
            }
        } else {
            super.handle(target, baseRequest, req, resp);
            return;
        }
        String realm = this.mBasicAuthCondition.getRealm();
        resp.setHeader("WWW-Authenticate", "BASIC realm=\"" + realm + "\"");
        resp.sendError(401, "Authorization Required");
    }

    private String decodeBase64Str(String base64encodedStr) {
        byte[] decodedBytes = Base64.getDecoder().decode(base64encodedStr.getBytes());
        String decodedStr = new String(decodedBytes);
        return decodedStr;
    }

    private _User parseAuthUserFromBase64(String enbase64encodedUserColonPassPart) {
        String userColonPassStr = this.decodeBase64Str(enbase64encodedUserColonPassPart);
        int firstColonPos = this.decodeBase64Str(enbase64encodedUserColonPassPart).indexOf(":");
        _User user = new _User();
        if (firstColonPos >= 0) {
            user.userName = userColonPassStr.substring(0, firstColonPos);
            user.password = userColonPassStr.substring(firstColonPos + 1);
        } else {
            user.userName = userColonPassStr;
        }
        return user;
    }

    private static class _User {
        public String userName;
        public String password;

        private _User() {
        }
    }
}

