/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jetty.basicauth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.riversun.jetty.basicauth.BasicAuth;
import org.riversun.jetty.basicauth.BasicAuthLogicCore;

public class BasicAuthSecurityHandler
extends ConstraintSecurityHandler {
    private BasicAuth mBasicAuth;
    private BasicAuthLogicCore mBasicAuthLogic = new BasicAuthLogicCore();

    public BasicAuthSecurityHandler setBasicAuth(BasicAuth basicAuth) {
        this.mBasicAuth = basicAuth;
        this.mBasicAuthLogic.setBasicAuth(basicAuth);
        this.init();
        return this;
    }

    private void init() {
        HashLoginService loginService = new HashLoginService();
        loginService.setName(this.mBasicAuth.getRealm());
        this.setAuthenticator((Authenticator)new BasicAuthenticator());
        this.setRealmName("realm");
        this.setLoginService((LoginService)loginService);
        UserStore userStore = new UserStore();
        LinkedHashMap pathRolesMap = new LinkedHashMap();
        for (BasicAuth.UserPath authPathModel : this.mBasicAuth.getUserPathList()) {
            String[] pathSpecs;
            String[] roles = new String[]{"role_for_" + authPathModel.userName};
            userStore.addUser(authPathModel.userName, (Credential)new Password(authPathModel.password), roles);
            String[] stringArray = pathSpecs = authPathModel.pathSpecs.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String pathSpec;
                String key = pathSpec = stringArray[i];
                List<String> roleList = null;
                if (pathRolesMap.containsKey(key)) {
                    roleList = (List)pathRolesMap.get(key);
                } else {
                    roleList = new ArrayList();
                    pathRolesMap.put(key, roleList);
                }
                roleList.add(roles[0]);
            }
        }
        for (String pathSpec : pathRolesMap.keySet()) {
            List roleList = (List)pathRolesMap.get(pathSpec);
            ConstraintMapping mapping = BasicAuthSecurityHandler.createMapping(pathSpec, roleList.toArray(new String[0]));
            this.addConstraintMapping(mapping);
        }
        loginService.setUserStore(userStore);
    }

    private static ConstraintMapping createMapping(String pathSpec, String[] roles) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(roles);
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec(pathSpec);
        return mapping;
    }

    public void handle(String pathInContext, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean isAuthenticationSuccess;
        String remoteAddr = this.getRemoteAddr(request);
        boolean needBasicAuth = true;
        if (needBasicAuth && (isAuthenticationSuccess = this.mBasicAuthLogic.handle("", baseRequest, request, response))) {
            this.getHandler().handle(pathInContext, baseRequest, request, response);
        }
    }

    public BasicAuthSecurityHandler addRetryBasicAuthExcludedPath(String path) {
        this.mBasicAuthLogic.addRetryBasicAuthExcludedPath(path);
        return this;
    }

    public BasicAuthSecurityHandler setRetryBasicAuth(boolean enabled) {
        this.mBasicAuthLogic.setRetryBasicAuth(enabled);
        return this;
    }

    public BasicAuthSecurityHandler setSkipBasicAuthCallback(BasicAuthLogicCore.SkipBasicAuthCallback listener) {
        this.mBasicAuthLogic.setSkipBasicAuthCallback(listener);
        return this;
    }

    private String getRemoteAddr(HttpServletRequest request) {
        String xff = request.getHeader("X-Forwarded-For");
        if (xff != null) {
            return xff;
        }
        return request.getRemoteAddr();
    }
}

