/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jetty.basicauth;

import java.util.ArrayList;
import java.util.List;

public class BasicAuth {
    private String realm;
    private List<UserPath> authPathList;

    private BasicAuth() {
    }

    String getRealm() {
        return this.realm;
    }

    List<UserPath> getUserPathList() {
        return this.authPathList;
    }

    private BasicAuth(Builder builder) {
        this.realm = builder.mRealm;
        this.authPathList = builder.mAuthPathList;
    }

    static final class UserPath {
        public String userName;
        public String password;
        public String pathSpecs;

        public UserPath(String userName, String password, String pathSpecs) {
            this.userName = userName;
            this.password = password;
            this.pathSpecs = pathSpecs;
        }
    }

    public static class Builder {
        private String mRealm;
        private List<UserPath> mAuthPathList;

        public Builder setRealm(String realm) {
            this.mRealm = realm;
            return this;
        }

        public Builder addUserPath(String userName, String password, String pathSpecs) {
            if (this.mAuthPathList == null) {
                this.mAuthPathList = new ArrayList<UserPath>();
            }
            this.mAuthPathList.add(new UserPath(userName, password, pathSpecs));
            return this;
        }

        public BasicAuth build() {
            return new BasicAuth(this);
        }
    }
}

