/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jetty.basicauth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.riversun.jetty.basicauth.BasicAuth;

public class BasicAuthLogicCore {
    private static final Logger LOGGER = Logger.getLogger(BasicAuthLogicCore.class.getName());
    private BasicAuth mBasicAuthCondition;
    private final Map<String, List<BasicAuth.UserPath>> mPathSpecUserMap = new LinkedHashMap<String, List<BasicAuth.UserPath>>();
    private boolean mForceShowDialogWhenNotAuthed = true;
    private final List<String> mRetryBasicAuthExcludedPath = new CopyOnWriteArrayList<String>();
    private String[] mWelcomeFiles = null;
    public SkipBasicAuthCallback mSkipBasicAuthCallback;

    public BasicAuthLogicCore setBasicAuth(BasicAuth basicAuth) {
        this.mBasicAuthCondition = basicAuth;
        List<BasicAuth.UserPath> userPathList = basicAuth.getUserPathList();
        for (BasicAuth.UserPath userPath : userPathList) {
            String[] pathSpecs;
            for (String pathSpec : pathSpecs = userPath.pathSpecs.split(",")) {
                List<BasicAuth.UserPath> storedUserPathList = this.mPathSpecUserMap.get(pathSpec);
                if (storedUserPathList == null) {
                    storedUserPathList = new ArrayList<BasicAuth.UserPath>();
                    this.mPathSpecUserMap.put(pathSpec, storedUserPathList);
                }
                storedUserPathList.add(userPath);
            }
        }
        return this;
    }

    private List<BasicAuth.UserPath> isBasicAuthNeeded(HttpServletRequest req) {
        ArrayList<BasicAuth.UserPath> allowedUserList = new ArrayList<BasicAuth.UserPath>();
        String requestUri = req.getRequestURI();
        Set<String> pathSpecSet = this.mPathSpecUserMap.keySet();
        for (String pathSpec : pathSpecSet) {
            String path;
            int asterPos = pathSpec.indexOf("*");
            if (asterPos >= 0) {
                path = pathSpec.substring(0, asterPos);
                if (!requestUri.startsWith(path)) continue;
                allowedUserList.addAll((Collection<BasicAuth.UserPath>)this.mPathSpecUserMap.get(pathSpec));
                continue;
            }
            path = pathSpec;
            if (!requestUri.equals(path)) continue;
            allowedUserList.addAll((Collection<BasicAuth.UserPath>)this.mPathSpecUserMap.get(pathSpec));
        }
        return allowedUserList;
    }

    void setWelcomeFilesAndRelatedPaths(String[] welcomeFiles) {
        if (this.mWelcomeFiles == null) {
            this.mWelcomeFiles = welcomeFiles;
            List<BasicAuth.UserPath> userPathList = this.mBasicAuthCondition.getUserPathList();
            for (BasicAuth.UserPath userPath : userPathList) {
                String[] pathSpecs;
                for (String pathSpec : pathSpecs = userPath.pathSpecs.split(",")) {
                    String[] separatorEnds;
                    for (String welcomeFile : welcomeFiles) {
                        if (!pathSpec.endsWith(welcomeFile)) continue;
                        String needToAddBasePath = pathSpec.substring(0, pathSpec.length() - welcomeFile.length());
                        LOGGER.fine("Welcome file interpolation:need to add path='" + needToAddBasePath + "' for '" + pathSpec + "'(welcomeFile)");
                        List<BasicAuth.UserPath> storedUserPathList = this.mPathSpecUserMap.get(needToAddBasePath);
                        if (storedUserPathList == null) {
                            storedUserPathList = new ArrayList<BasicAuth.UserPath>();
                            this.mPathSpecUserMap.put(needToAddBasePath, storedUserPathList);
                        }
                        if (storedUserPathList.contains(userPath)) continue;
                        userPath.pathSpecs = userPath.pathSpecs + "," + needToAddBasePath;
                        LOGGER.fine("Welcome file interpolation:Added '" + needToAddBasePath + "' for " + userPath.userName);
                        storedUserPathList.add(userPath);
                    }
                    for (String separatorEnd : separatorEnds = new String[]{"/", "/*"}) {
                        if (!pathSpec.endsWith(separatorEnd)) continue;
                        String needToAddBasePath = pathSpec.substring(0, pathSpec.length() - separatorEnd.length());
                        LOGGER.fine("Path-separator interpolation:need to add path='" + needToAddBasePath + "' for '" + pathSpec + "'(welcomeFile)");
                        List<BasicAuth.UserPath> storedUserPathList = this.mPathSpecUserMap.get(needToAddBasePath);
                        if (storedUserPathList == null) {
                            storedUserPathList = new ArrayList<BasicAuth.UserPath>();
                            this.mPathSpecUserMap.put(needToAddBasePath, storedUserPathList);
                        }
                        if (storedUserPathList.contains(userPath)) continue;
                        userPath.pathSpecs = userPath.pathSpecs + "," + needToAddBasePath;
                        LOGGER.fine("Path-separator interpolation:Added '" + needToAddBasePath + "' for " + userPath.userName);
                        storedUserPathList.add(userPath);
                    }
                }
            }
        }
    }

    boolean handle(String target, Request baseRequest, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (this.mSkipBasicAuthCallback != null && this.mSkipBasicAuthCallback.checkSkipBasicAuth(req)) {
            return true;
        }
        String requestUri = req.getRequestURI();
        LOGGER.fine("requestUri=" + requestUri);
        String authHeader = req.getHeader("Authorization");
        List<BasicAuth.UserPath> permitUserList = this.isBasicAuthNeeded(req);
        if (permitUserList != null && permitUserList.size() > 0) {
            if (authHeader != null && authHeader.startsWith("Basic ")) {
                Object userPath;
                String base64encodedUserColonPassPart = authHeader.substring(authHeader.indexOf(" ") + 1);
                _User user = this.parseAuthUserFromBase64(base64encodedUserColonPassPart);
                LOGGER.fine("Access from user:userNmae=" + user.userName + " pass=" + user.password + " for path=" + requestUri);
                boolean isAuthenticated = false;
                BasicAuth.UserPath finalAllowedUser = null;
                for (BasicAuth.UserPath allowedUser : permitUserList) {
                    if (!allowedUser.userName.equals(user.userName) || !allowedUser.password.equals(user.password)) continue;
                    isAuthenticated = true;
                    finalAllowedUser = allowedUser;
                    break;
                }
                if (isAuthenticated) {
                    LOGGER.fine("Authentication success! user:userNmae=" + user.userName + " has permission to access " + finalAllowedUser.pathSpecs);
                    return true;
                }
                Map<String, BasicAuth.UserPath> userNameUserPathMap = this.mBasicAuthCondition.getUserNameUserPathMap();
                if (userNameUserPathMap != null && (userPath = userNameUserPathMap.get(user.userName)) != null) {
                    LOGGER.fine("Authentication fail! user:userNmae=" + user.userName + " don't have permission to access " + requestUri + " user has permission to access " + ((BasicAuth.UserPath)userPath).pathSpecs);
                }
                for (String excludedPath : this.mRetryBasicAuthExcludedPath) {
                    if (!excludedPath.equals(requestUri)) continue;
                    LOGGER.fine("ExcludedPath found " + requestUri + " send forbidden message");
                    resp.sendError(403, "You don't have permission to access.");
                    return false;
                }
                if (this.mForceShowDialogWhenNotAuthed) {
                    String realm = this.mBasicAuthCondition.getRealm();
                    resp.setHeader("WWW-Authenticate", "BASIC realm=\"" + realm + "\"");
                    resp.sendError(401, "Authorization Required");
                } else {
                    resp.sendError(403, "You don't have permission to access.");
                }
                return false;
            }
        } else {
            LOGGER.fine("No authentication is needed.Free to access. " + requestUri);
            return true;
        }
        String realm = this.mBasicAuthCondition.getRealm();
        resp.setHeader("WWW-Authenticate", "BASIC realm=\"" + realm + "\"");
        resp.sendError(401, "Authorization Required");
        return false;
    }

    public void setSkipBasicAuthCallback(SkipBasicAuthCallback callback) {
        this.mSkipBasicAuthCallback = callback;
    }

    private String decodeBase64Str(String base64encodedStr) {
        byte[] decodedBytes = Base64.getDecoder().decode(base64encodedStr.getBytes());
        String decodedStr = new String(decodedBytes);
        return decodedStr;
    }

    private _User parseAuthUserFromBase64(String enbase64encodedUserColonPassPart) {
        String userColonPassStr = this.decodeBase64Str(enbase64encodedUserColonPassPart);
        int firstColonPos = this.decodeBase64Str(enbase64encodedUserColonPassPart).indexOf(":");
        _User user = new _User();
        if (firstColonPos >= 0) {
            user.userName = userColonPassStr.substring(0, firstColonPos);
            user.password = userColonPassStr.substring(firstColonPos + 1);
        } else {
            user.userName = userColonPassStr;
        }
        return user;
    }

    public BasicAuthLogicCore addRetryBasicAuthExcludedPath(String path) {
        this.mRetryBasicAuthExcludedPath.add(path);
        return this;
    }

    public BasicAuthLogicCore setRetryBasicAuth(boolean enabled) {
        this.mForceShowDialogWhenNotAuthed = enabled;
        return this;
    }

    private static class _User {
        public String userName;
        public String password;

        private _User() {
        }
    }

    public static interface SkipBasicAuthCallback {
        public boolean checkSkipBasicAuth(HttpServletRequest var1);
    }
}

