/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.jetty.basicauth;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BasicAuth {
    private String realm;
    private List<UserPath> authPathList;
    private Map<String, UserPath> userNameUserPathMap;

    private BasicAuth() {
    }

    String getRealm() {
        return this.realm;
    }

    List<UserPath> getUserPathList() {
        return this.authPathList;
    }

    Map<String, UserPath> getUserNameUserPathMap() {
        return this.userNameUserPathMap;
    }

    private BasicAuth(Builder builder) {
        this.realm = builder.mRealm;
        this.authPathList = builder.mAuthPathList;
        this.userNameUserPathMap = builder.mUserNameUserPathMap;
    }

    static final class UserPath {
        public String userName;
        public String password;
        public String pathSpecs;

        public UserPath(String userName, String password, String pathSpecs) {
            this.userName = userName;
            this.password = password;
            this.pathSpecs = pathSpecs;
        }
    }

    public static class Builder {
        private String mRealm;
        private List<UserPath> mAuthPathList;
        private Map<String, UserPath> mUserNameUserPathMap;

        public Builder setRealm(String realm) {
            this.mRealm = realm;
            return this;
        }

        public Builder addUserPath(String userName, String password, String pathSpecs) {
            if (this.mAuthPathList == null) {
                this.mAuthPathList = new ArrayList<UserPath>();
            }
            if (this.mUserNameUserPathMap == null) {
                this.mUserNameUserPathMap = new LinkedHashMap<String, UserPath>();
            }
            UserPath up = new UserPath(userName, password, pathSpecs);
            this.mAuthPathList.add(up);
            this.mUserNameUserPathMap.put(userName, up);
            return this;
        }

        public BasicAuth build() {
            return new BasicAuth(this);
        }
    }
}

