/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.sse;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSEHelper {
    protected List<EventTarget> mEventTargetList = new CopyOnWriteArrayList<EventTarget>();

    public List<EventTarget> getTargetList() {
        return this.mEventTargetList;
    }

    public void addTarget(HttpServletRequest req) throws IOException {
        this.addTarget(new EventTarget(req));
    }

    public void addTarget(EventTarget eventTarget) throws IOException {
        this.mEventTargetList.add(eventTarget.ok().open());
    }

    public List<EventTarget> broadcast(String event, String data) {
        return this.broadcast(new MessageEvent(event, data));
    }

    public List<EventTarget> broadcast(MessageEvent messageEvent) {
        for (EventTarget eventTarget : this.mEventTargetList) {
            try {
                eventTarget.send(messageEvent);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.mEventTargetList.remove(eventTarget);
            }
        }
        return this.mEventTargetList;
    }

    public void clearTargets() {
        for (EventTarget eventTarget : this.mEventTargetList) {
            try {
                eventTarget.close();
            }
            catch (Exception exception) {}
        }
        this.mEventTargetList.clear();
    }

    public static class MessageEvent {
        private final String data;
        private final String event;
        private final Integer retry;
        private final String id;
        private String toStringCache;

        public MessageEvent(String event, String data) {
            this.data = data;
            this.event = event;
            this.retry = null;
            this.id = null;
            this.build();
        }

        public MessageEvent(String event, String data, Integer retry, String id) {
            this.data = data;
            this.event = event;
            this.retry = retry;
            this.id = id;
            this.build();
        }

        public void build() {
            StringBuilder sb = new StringBuilder();
            if (this.event != null) {
                sb.append("event: ").append(this.event.replace("\n", "")).append('\n');
            }
            if (this.data != null) {
                for (String s : this.data.split("\n")) {
                    sb.append("data: ").append(s).append('\n');
                }
            }
            if (this.retry != null) {
                sb.append("retry: ").append(this.retry).append('\n');
            }
            if (this.id != null) {
                sb.append("id: ").append(this.id.replace("\n", "")).append('\n');
            }
            sb.append('\n');
            this.toStringCache = sb.toString();
        }

        public String toString() {
            return this.toStringCache;
        }
    }

    public static class EventTarget {
        private final AsyncContext mAsyncContext;
        private boolean mIsCompleted = false;

        public EventTarget(HttpServletRequest req) {
            this.mAsyncContext = req.startAsync();
            this.mAsyncContext.setTimeout(0L);
            this.mAsyncContext.addListener((AsyncListener)new AsyncListenerImpl());
        }

        public EventTarget ok() {
            HttpServletResponse res = this.getAsyncResponse();
            res.setStatus(200);
            res.setContentType("text/event-stream");
            res.setCharacterEncoding("UTF-8");
            res.setHeader("Cache-Control", "no-cache");
            res.setHeader("Connection", "keep-alive");
            return this;
        }

        public EventTarget open() throws IOException {
            ServletOutputStream os = this.getAsyncResponseStream();
            os.print("event: open\n\n");
            os.flush();
            return this;
        }

        public EventTarget send(String event, String data) throws IOException {
            ServletOutputStream os = this.getAsyncResponseStream();
            os.print(new MessageEvent(event, data).toString());
            os.flush();
            return this;
        }

        public EventTarget send(MessageEvent messageEvent) throws IOException {
            try {
                ServletOutputStream os = this.getAsyncResponseStream();
                os.print(messageEvent.toString());
                os.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        private HttpServletResponse getAsyncResponse() {
            HttpServletResponse res = (HttpServletResponse)this.mAsyncContext.getResponse();
            return res;
        }

        private ServletOutputStream getAsyncResponseStream() throws IOException {
            HttpServletResponse res = (HttpServletResponse)this.mAsyncContext.getResponse();
            ServletOutputStream os = res.getOutputStream();
            return os;
        }

        public void close() {
            if (!this.mIsCompleted) {
                this.mIsCompleted = true;
                this.mAsyncContext.complete();
            }
        }

        private class AsyncListenerImpl
        implements AsyncListener {
            private AsyncListenerImpl() {
            }

            public void onComplete(AsyncEvent event) throws IOException {
                EventTarget.this.mIsCompleted = true;
                System.out.println("onComplete");
            }

            public void onTimeout(AsyncEvent event) throws IOException {
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        }
    }
}

