/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.linebot;

import com.google.common.io.ByteStreams;
import com.linecorp.bot.client.LineMessagingClientImpl;
import com.linecorp.bot.client.LineMessagingServiceBuilder;
import com.linecorp.bot.client.LineSignatureValidator;
import com.linecorp.bot.client.MessageContentResponse;
import com.linecorp.bot.model.ReplyMessage;
import com.linecorp.bot.model.event.BeaconEvent;
import com.linecorp.bot.model.event.CallbackRequest;
import com.linecorp.bot.model.event.Event;
import com.linecorp.bot.model.event.FollowEvent;
import com.linecorp.bot.model.event.JoinEvent;
import com.linecorp.bot.model.event.LeaveEvent;
import com.linecorp.bot.model.event.MessageEvent;
import com.linecorp.bot.model.event.PostbackEvent;
import com.linecorp.bot.model.event.UnfollowEvent;
import com.linecorp.bot.model.event.message.AudioMessageContent;
import com.linecorp.bot.model.event.message.ImageMessageContent;
import com.linecorp.bot.model.event.message.LocationMessageContent;
import com.linecorp.bot.model.event.message.MessageContent;
import com.linecorp.bot.model.event.message.StickerMessageContent;
import com.linecorp.bot.model.event.message.TextMessageContent;
import com.linecorp.bot.model.event.message.VideoMessageContent;
import com.linecorp.bot.model.profile.UserProfileResponse;
import com.linecorp.bot.servlet.LineBotCallbackException;
import com.linecorp.bot.servlet.LineBotCallbackRequestParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import retrofit2.Response;

public abstract class LineBotServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(LineBotServlet.class.getName());
    protected HttpServletRequest req;
    protected HttpServletResponse res;

    public abstract String getChannelSecret();

    public abstract String getChannelAccessToken();

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.req = req;
        this.res = res;
        super.service(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        LOGGER.fine("callback from LINE received.");
        LineSignatureValidator validator = new LineSignatureValidator(this.getChannelSecret().getBytes(StandardCharsets.UTF_8));
        LineBotCallbackRequestParser parser = new LineBotCallbackRequestParser(validator);
        String signature = req.getHeader("X-Line-Signature");
        byte[] jsonData = ByteStreams.toByteArray((InputStream)req.getInputStream());
        String jsonText = new String(jsonData, StandardCharsets.UTF_8);
        if (LOGGER.isLoggable(Level.FINEST)) {
            JSONObject jsonObj = new JSONObject(jsonText);
            LOGGER.finest("RESPONSE JSON\n" + jsonObj.toString(4));
        }
        try {
            CallbackRequest callbackRequest = parser.handle(signature, jsonText);
            List eventList = callbackRequest.getEvents();
            for (int i = 0; i < eventList.size(); ++i) {
                Event event = (Event)eventList.get(i);
                LOGGER.fine("event[" + i + "]=" + event);
                if (event == null) continue;
                if (event instanceof MessageEvent) {
                    MessageEvent messageEvent = (MessageEvent)event;
                    this.reply(this.handleMessageEvent(messageEvent));
                    continue;
                }
                if (event instanceof UnfollowEvent) {
                    UnfollowEvent unfollowEvent = (UnfollowEvent)event;
                    this.handleUnfollowEvent(unfollowEvent);
                    continue;
                }
                if (event instanceof FollowEvent) {
                    FollowEvent followEvent = (FollowEvent)event;
                    this.reply(this.handleFollowEvent(followEvent));
                    continue;
                }
                if (event instanceof JoinEvent) {
                    JoinEvent joinEvent = (JoinEvent)event;
                    this.reply(this.handleJoinEvent(joinEvent));
                    continue;
                }
                if (event instanceof LeaveEvent) {
                    LeaveEvent leaveEvent = (LeaveEvent)event;
                    this.handleLeaveEvent(leaveEvent);
                    continue;
                }
                if (event instanceof PostbackEvent) {
                    PostbackEvent postbackEvent = (PostbackEvent)event;
                    this.reply(this.handlePostbackEvent(postbackEvent));
                    continue;
                }
                if (!(event instanceof BeaconEvent)) continue;
                BeaconEvent beaconEvent = (BeaconEvent)event;
                this.reply(this.handleBeaconEvent(beaconEvent));
            }
        }
        catch (LineBotCallbackException e) {
            e.printStackTrace();
        }
        res.setStatus(200);
    }

    private ReplyMessage handleMessageEvent(MessageEvent<?> messageEvent) throws IOException {
        MessageContent messageContent = messageEvent.getMessage();
        if (messageContent == null) {
            return null;
        }
        LOGGER.fine("message content=" + messageContent);
        if (messageContent instanceof TextMessageContent) {
            MessageEvent<?> event = messageEvent;
            return this.handleTextMessageEvent(event);
        }
        if (messageContent instanceof ImageMessageContent) {
            MessageEvent<?> event = messageEvent;
            return this.handleImageMessageEvent(event);
        }
        if (messageContent instanceof LocationMessageContent) {
            MessageEvent<?> event = messageEvent;
            return this.handleLocationMessageEvent(event);
        }
        if (messageContent instanceof AudioMessageContent) {
            MessageEvent<?> event = messageEvent;
            return this.handleAudioMessageEvent(event);
        }
        if (messageContent instanceof VideoMessageContent) {
            MessageEvent<?> event = messageEvent;
            return this.handleVideoMessageEvent(event);
        }
        if (messageContent instanceof StickerMessageContent) {
            MessageEvent<?> event = messageEvent;
            return this.handleStickerMessageEvent(event);
        }
        return null;
    }

    protected ReplyMessage handleTextMessageEvent(MessageEvent<TextMessageContent> event) throws IOException {
        LOGGER.fine("do handle TextMessageEvent ");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected ReplyMessage handleImageMessageEvent(MessageEvent<ImageMessageContent> event) throws IOException {
        LOGGER.fine("do handle ImageMessageEvent");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected ReplyMessage handleLocationMessageEvent(MessageEvent<LocationMessageContent> event) {
        LOGGER.fine("do handle LocationMessageEvent");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected ReplyMessage handleStickerMessageEvent(MessageEvent<StickerMessageContent> event) {
        LOGGER.fine("do handle StickerMessageEvent");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected ReplyMessage handleAudioMessageEvent(MessageEvent<AudioMessageContent> event) throws IOException {
        LOGGER.fine("do handle AudioMessageEvent");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected ReplyMessage handleVideoMessageEvent(MessageEvent<VideoMessageContent> event) throws IOException {
        LOGGER.fine("do handle VideoMessageEvent");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected void handleUnfollowEvent(UnfollowEvent event) {
        LOGGER.fine("do handle UnfollowEvent");
        this.handleDefaultMessageEvent((Event)event);
    }

    protected ReplyMessage handleFollowEvent(FollowEvent event) {
        LOGGER.fine("do handle FollowEvent");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected ReplyMessage handleJoinEvent(JoinEvent event) {
        LOGGER.fine("do handle JoinEvent");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected void handleLeaveEvent(LeaveEvent event) {
        LOGGER.fine("do handle LeaveEvent");
        this.handleDefaultMessageEvent((Event)event);
    }

    protected ReplyMessage handlePostbackEvent(PostbackEvent event) {
        LOGGER.fine("do handle PostbackEvent");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected ReplyMessage handleBeaconEvent(BeaconEvent event) {
        LOGGER.fine("do handle BeaconEvnt");
        return this.handleDefaultMessageEvent((Event)event);
    }

    protected abstract ReplyMessage handleDefaultMessageEvent(Event var1);

    private void reply(ReplyMessage replyMessage) throws IOException {
        LOGGER.fine("send reply replyMessage=" + replyMessage);
        if (replyMessage == null) {
            return;
        }
        Response response = LineMessagingServiceBuilder.create((String)this.getChannelAccessToken()).build().replyMessage(replyMessage).execute();
        LOGGER.fine("send reply response=" + response.raw().toString());
    }

    public final UserProfileResponse getUserProfile(String userId) {
        LineMessagingClientImpl lineMessagingClient = new LineMessagingClientImpl(LineMessagingServiceBuilder.create((String)this.getChannelAccessToken()).build());
        try {
            UserProfileResponse userProfileResponse = (UserProfileResponse)lineMessagingClient.getProfile(userId).get();
            return userProfileResponse;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public final InputStream getContentStream(MessageContent content) {
        String messageId = content.getId();
        LineMessagingClientImpl lineMessagingClient = new LineMessagingClientImpl(LineMessagingServiceBuilder.create((String)this.getChannelAccessToken()).build());
        try {
            MessageContentResponse res = (MessageContentResponse)lineMessagingClient.getMessageContent(messageId).get();
            InputStream contentStream = res.getStream();
            return contentStream;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

