/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.okhttp3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class OkHttp3CookieHelper {
    private final Map<String, List<Cookie>> mServerCookieStore = new ConcurrentHashMap<String, List<Cookie>>();
    private Map<String, List<Cookie>> mClientCookieStore = new ConcurrentHashMap<String, List<Cookie>>();
    private final CookieJar mCookieJar = new CookieJar(){

        public List<Cookie> loadForRequest(HttpUrl url) {
            List clientCookieStore;
            ArrayList serverCookieList = (ArrayList)OkHttp3CookieHelper.this.mServerCookieStore.get(url.host());
            if (serverCookieList == null) {
                serverCookieList = new ArrayList();
            }
            if ((clientCookieStore = (List)OkHttp3CookieHelper.this.mClientCookieStore.get(url.host())) != null) {
                serverCookieList.addAll(clientCookieStore);
            }
            return serverCookieList != null ? serverCookieList : new ArrayList();
        }

        public void saveFromResponse(HttpUrl url, List<Cookie> unmodifiableCookieList) {
            OkHttp3CookieHelper.this.mServerCookieStore.put(url.host(), new ArrayList<Cookie>(unmodifiableCookieList));
        }
    };

    public void setCookie(String url, Cookie cookie) {
        String host = HttpUrl.parse((String)url).host();
        List<Cookie> cookieListForUrl = this.mClientCookieStore.get(host);
        if (cookieListForUrl == null) {
            cookieListForUrl = new ArrayList<Cookie>();
            this.mClientCookieStore.put(host, cookieListForUrl);
        }
        this.putCookie(cookieListForUrl, cookie);
    }

    public void setCookie(String url, String cookieName, String cookieValue) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        this.setCookie(url, Cookie.parse((HttpUrl)httpUrl, (String)(cookieName + "=" + cookieValue)));
    }

    public void setCookie(HttpUrl httpUrl, String cookieName, String cookieValue) {
        this.setCookie(httpUrl.host(), Cookie.parse((HttpUrl)httpUrl, (String)(cookieName + "=" + cookieValue)));
    }

    public CookieJar cookieJar() {
        return this.mCookieJar;
    }

    private void putCookie(List<Cookie> storedCookieList, Cookie newCookie) {
        Cookie oldCookie = null;
        for (Cookie storedCookie : storedCookieList) {
            String newCookieKey;
            String oldCookieKey = storedCookie.name() + storedCookie.path();
            if (!oldCookieKey.equals(newCookieKey = newCookie.name() + newCookie.path())) continue;
            oldCookie = storedCookie;
            break;
        }
        if (oldCookie != null) {
            storedCookieList.remove(oldCookie);
        }
        storedCookieList.add(newCookie);
    }
}

