/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.solidui.jmenuitem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.riversun.solidui.jmenuitem.SolidMenuItemUI;

public class SolidMenuItem
extends JMenuItem {
    JLabel mTextLabel;
    JLabel mShortcutLabel;
    Condition mCondition;

    public SolidMenuItem(Condition creationCondition) {
        this.mCondition = creationCondition;
        this.setName(creationCondition.getText());
        this.setLayout(new GridBagLayout());
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this.setAccelerator(creationCondition.accelerator);
        GridBagConstraints constraints = new GridBagConstraints();
        this.mTextLabel = new JLabel(creationCondition.text);
        this.mTextLabel.setFont(UIManager.getFont("MenuItem.font"));
        this.mTextLabel.setForeground(UIManager.getColor("MenuItem.foreground"));
        this.mTextLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(creationCondition.marginVertical, creationCondition.marginLeft, creationCondition.marginVertical, 0);
        this.add((Component)this.mTextLabel, constraints);
        this.mShortcutLabel = new JLabel(creationCondition.shortcutText);
        this.mShortcutLabel.setFont(UIManager.getFont("MenuItem.font"));
        this.mShortcutLabel.setForeground(UIManager.getColor("MenuItem.acceleratorForeground"));
        this.mShortcutLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(creationCondition.marginVertical, creationCondition.marginVertical, creationCondition.marginVertical, creationCondition.marginVertical);
        this.add((Component)this.mShortcutLabel, constraints);
        this.setUI(new SolidMenuItemUI(this.mCondition));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.getModel().isArmed() || this.isSelected()) {
            g2d.setColor(UIManager.getColor("MenuItem.selectionBackground"));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int height = fm.getHeight() + this.getInsets().top + this.getInsets().bottom + this.mCondition.marginVertical * 2;
        int width = fm.stringWidth(this.mTextLabel.getText()) + fm.stringWidth(this.mShortcutLabel.getText()) + 80;
        preferredSize.setSize(this.mCondition.width == 0 ? width : this.mCondition.width, height);
        return preferredSize;
    }

    public static class Condition {
        String text;
        String shortcutText;
        KeyStroke accelerator;
        int marginVertical;
        int marginLeft;
        int width;
        Color colorOnFocus;

        public String getText() {
            return this.text;
        }

        public String getShortcutText() {
            return this.shortcutText;
        }

        public KeyStroke getAccelerator() {
            return this.accelerator;
        }

        public int getMarginVertical() {
            return this.marginVertical;
        }

        public int getMarginLeft() {
            return this.marginLeft;
        }

        public int getWidth() {
            return this.width;
        }

        public Color getColor() {
            return this.colorOnFocus;
        }

        private Condition(Builder builder) {
            this.text = builder.text;
            this.shortcutText = builder.shortcutText;
            this.accelerator = builder.accelerator;
            this.marginVertical = builder.marginVertical;
            this.marginLeft = builder.marginLeft;
            this.width = builder.width;
            this.colorOnFocus = builder.color;
        }

        public String toString() {
            return "Condition [text=" + this.text + ", shortcutText=" + this.shortcutText + ", accelerator=" + this.accelerator + ", marginVertical=" + this.marginVertical + ", marginLeft=" + this.marginLeft + ", width=" + this.width + "]";
        }

        public static class Builder {
            private String text;
            private String shortcutText;
            private KeyStroke accelerator;
            private int marginVertical = 4;
            private int marginLeft = 8;
            private int width;
            private Color color;

            public Builder colorOnFocus(Color color) {
                this.color = color;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder shortcutText(String shortcutText) {
                this.shortcutText = shortcutText;
                return this;
            }

            public Builder accelerator(KeyStroke accelerator) {
                this.accelerator = accelerator;
                return this;
            }

            public Builder marginVertical(int marginVertical) {
                this.marginVertical = marginVertical;
                return this;
            }

            public Builder marginLeft(int marginLeft) {
                this.marginLeft = marginLeft;
                return this;
            }

            public Builder width(int width) {
                this.width = width;
                return this;
            }

            public Condition build() {
                return new Condition(this);
            }
        }
    }
}

