/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.string_grabber;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCropper {
    private static final boolean handlingBlankStrEnabled = true;

    public List<String> getStringEnclosedIn(String srcStr, String startToken, String endToken) {
        List<StrPosition> resultList = this.getStringEnclosedInWithDetails(srcStr, startToken, endToken);
        ArrayList<String> retList = new ArrayList<String>();
        for (StrPosition sp : resultList) {
            retList.add(sp.str);
        }
        return retList;
    }

    public List<StrPosition> getStringEnclosedInWithDetails(String srcStr, String startToken, String endToken) {
        StrPosition discoveryStr;
        ArrayList<StrPosition> retList = new ArrayList<StrPosition>();
        boolean searchInProgress = true;
        int cursor = 0;
        String workStr = srcStr;
        while ((discoveryStr = this.getStringEnclosedInFirstWithDetails(workStr, startToken, endToken)) != null) {
            String discoveredStr = discoveryStr.str;
            int startIdx = discoveryStr.startIndex;
            int endIdx = discoveryStr.startIndex + discoveredStr.length() - 1;
            if ("".equals(discoveredStr)) {
                endIdx = startIdx;
            }
            if (discoveredStr == null) {
                searchInProgress = false;
            } else {
                StrPosition currentDiscovery = new StrPosition();
                currentDiscovery.str = discoveredStr;
                currentDiscovery.startIndex = startIdx + cursor;
                currentDiscovery.endIndex = endIdx + cursor;
                retList.add(currentDiscovery);
            }
            workStr = this.removeHead(workStr, startIdx);
            cursor += startIdx;
            if (workStr.indexOf(startToken) < 0) {
                searchInProgress = false;
            }
            if (searchInProgress) continue;
        }
        return retList;
    }

    public String getStringEnclosedInFirst(String srcStr, String startToken, String endToken) {
        return this.getStringEnclosedInFirstWithDetails((String)srcStr, (String)startToken, (String)endToken).str;
    }

    public StrPosition getStringEnclosedInFirstWithDetails(String srcStr, String startToken, String endToken) {
        StrPosition result = new StrPosition();
        boolean useTailMode = true;
        StrPosition stringAfterToken = this.getAfterOfWithDetails(srcStr, startToken);
        StrPosition stringBeforeToken = this.getBeforeOfWithDetails(stringAfterToken.str, endToken);
        if (stringBeforeToken == null) {
            return null;
        }
        int startIndex = stringAfterToken.startIndex;
        int endIndex = startIndex + stringBeforeToken.str.length() - 1;
        if ("".equals(stringBeforeToken.str)) {
            endIndex = startIndex;
        }
        result.str = stringBeforeToken.str;
        result.startIndex = startIndex;
        result.endIndex = endIndex;
        int tailOfIdx = this.tailOf(result.str, startToken);
        if (tailOfIdx >= 0) {
            result.str = this.removeHead(result.str, tailOfIdx + startToken.length());
            result.startIndex += tailOfIdx + 1;
            result.endIndex = "".equals(result.str) ? result.startIndex : result.startIndex + result.str.length() - 1;
        }
        return result;
    }

    public String stringAt(String srcStr, int index) {
        if (0 <= index && index < srcStr.length()) {
            return String.valueOf(srcStr.charAt(index));
        }
        return "";
    }

    public String getBeforeOf(String srcStr, String token) {
        return this.getBeforeOfWithDetails((String)srcStr, (String)token).str;
    }

    public StrPosition getBeforeOfWithDetails(String srcStr, String token) {
        StrPosition retVal = new StrPosition();
        if (this.isBlank(srcStr) || this.isBlank(token)) {
            return retVal;
        }
        int tokenStartIndex = srcStr.indexOf(token);
        if (tokenStartIndex < 0) {
            return null;
        }
        String beforeTokenStr = this.getLeftOf(srcStr, tokenStartIndex);
        retVal.startIndex = 0;
        retVal.endIndex = tokenStartIndex - 1;
        retVal.str = beforeTokenStr;
        return retVal;
    }

    public String getAfterOf(String srcStr, String token, boolean useTailSearch) {
        return this.getAfterOfWithDetails((String)srcStr, (String)token, (boolean)useTailSearch).str;
    }

    public String getAfterOf(String srcStr, String token) {
        return this.getAfterOfWithDetails((String)srcStr, (String)token).str;
    }

    public StrPosition getAfterOfWithDetails(String srcStr, String token) {
        return this.getAfterOfWithDetails(srcStr, token, true);
    }

    public StrPosition getAfterOfWithDetails(String srcStr, String token, boolean useTailSearch) {
        String afterTokenStr;
        StrPosition retVal = new StrPosition();
        if (this.isBlank(srcStr) || this.isBlank(token)) {
            return retVal;
        }
        int tokenStartIndex = useTailSearch ? this.tailOf(srcStr, token) : srcStr.indexOf(token);
        if (tokenStartIndex < 0) {
            return retVal;
        }
        int tokenEndIndex = tokenStartIndex + token.length() - 1;
        int removeHeadCount = tokenEndIndex + 1;
        retVal.str = afterTokenStr = this.removeHead(srcStr, removeHeadCount);
        retVal.startIndex = tokenEndIndex + 1;
        retVal.endIndex = srcStr.length() - 1;
        return retVal;
    }

    public int tailOf(String srcStr, String searchStr) {
        if (this.isBlank(srcStr) || this.isBlank(searchStr)) {
            return -1;
        }
        int cursor = -1;
        boolean loop = true;
        boolean firstTokenAlreadyFound = false;
        do {
            int idx;
            if ((idx = srcStr.indexOf(searchStr)) >= 0) {
                if (firstTokenAlreadyFound && idx >= searchStr.length()) {
                    loop = false;
                    break;
                }
                ++cursor;
                if (idx == 0 && !firstTokenAlreadyFound) {
                    firstTokenAlreadyFound = true;
                }
                srcStr = this.removeHead(srcStr, 1);
                continue;
            }
            loop = false;
        } while (loop);
        return cursor;
    }

    public String removeTail(String srcStr, int charCount) {
        return this.getLeftOf(srcStr, srcStr.length() - charCount);
    }

    public String removeHead(String srcStr, int charCount) {
        return this.getRightOf(srcStr, srcStr.length() - charCount);
    }

    public String getLeftOf(String srcStr, int charCount) {
        String retValue = "";
        if (this.isNotBlank(srcStr)) {
            int length = srcStr.length();
            retValue = charCount < length ? srcStr.substring(0, charCount) : srcStr;
        }
        return retValue;
    }

    public String getRightOf(String srcStr, int charCount) {
        String retVal = "";
        if (this.isNotBlank(srcStr)) {
            int length = srcStr.length();
            retVal = charCount < length ? srcStr.substring(length - charCount, length) : srcStr;
        }
        return retVal;
    }

    public List<String> splitByIndex(String srcStr, Integer ... splitPoint) {
        List<StrPosition> strPosList = this.splitByIndexWithDetail(srcStr, splitPoint);
        ArrayList<String> resultList = new ArrayList<String>();
        for (StrPosition strPos : strPosList) {
            resultList.add(strPos.str);
        }
        return resultList;
    }

    public List<StrPosition> splitByIndexWithDetail(String srcStr, Integer ... splitPoint) {
        ArrayList<StrPosition> resultList = new ArrayList<StrPosition>();
        if (splitPoint == null || splitPoint.length == 0) {
            return resultList;
        }
        int cursor = 0;
        int cutStartIndex = 0;
        int cutEndIndex = 0;
        int lastCharIndex = srcStr.length() - 1;
        for (int i = 0; i < splitPoint.length; ++i) {
            cutStartIndex = cursor;
            cutEndIndex = splitPoint[i];
            if (cutEndIndex < 0) continue;
            if (cutStartIndex > lastCharIndex) break;
            if (cutEndIndex > lastCharIndex) {
                cutEndIndex = lastCharIndex;
            }
            String blockStr = this.substring(srcStr, cutStartIndex, cutEndIndex);
            StrPosition strPos = new StrPosition();
            strPos.str = blockStr;
            strPos.startIndex = cutStartIndex;
            strPos.endIndex = cutEndIndex;
            resultList.add(strPos);
            cursor = cutEndIndex + 1;
        }
        if (cutEndIndex < lastCharIndex) {
            cutEndIndex = lastCharIndex;
            cutStartIndex = cursor;
            String lastBlockStr = this.substring(srcStr, cutStartIndex, cutEndIndex);
            StrPosition strPos = new StrPosition();
            strPos.str = lastBlockStr;
            strPos.startIndex = cutStartIndex;
            strPos.endIndex = cutEndIndex;
            resultList.add(strPos);
        }
        return resultList;
    }

    private String substring(String srcStr, int startIdx, int endIndex) {
        return srcStr.substring(startIdx, endIndex + 1);
    }

    public boolean isNotBlank(String str) {
        return !this.isBlank(str);
    }

    public boolean isBlank(String str) {
        return str == null || "".equals(str);
    }

    public static class StrPosition {
        public String str = "";
        public int startIndex = -1;
        public int endIndex = -1;

        public String toString() {
            return "StrPosition [str=" + this.str + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + "]";
        }
    }
}

