/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.string_grabber;

import java.util.ArrayList;
import java.util.List;
import org.riversun.string_grabber.StringCropper;
import org.riversun.string_grabber.StringGrabberList;

public class StringGrabber {
    private StringBuilder sb;
    private StringCropper cropper;
    private static String sNewLine = "\n";

    public StringGrabber() {
        this("");
    }

    public StringGrabber(String str) {
        this.set(str);
    }

    public StringGrabber(StringGrabber sg) {
        this.set(sg.sb.toString());
    }

    public static void setNewLine(String newLine) {
        sNewLine = newLine;
    }

    public StringGrabber copy() {
        return new StringGrabber(this);
    }

    public StringGrabber append(String str) {
        this.sb.append(str);
        return this;
    }

    public StringGrabber set(String str) {
        if (str == null) {
            str = "";
        }
        return this.set(new StringBuilder(str));
    }

    public StringGrabber set(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        this.sb = stringBuilder;
        return this;
    }

    public StringGrabber removeTail() {
        this.removeTail(1);
        return this;
    }

    public StringGrabber removeHead(int cnt) {
        try {
            this.sb.delete(0, cnt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public StringGrabber removeTail(int cnt) {
        int leng = this.sb.length();
        try {
            this.sb.delete(leng - cnt, leng);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public StringGrabber removeHeadConsecutiveChars(char charToRemove) {
        boolean loop = true;
        if (this.sb.length() > 0) {
            while (loop) {
                if (this.sb.charAt(0) == charToRemove) {
                    this.removeHead(1);
                    continue;
                }
                loop = false;
            }
        }
        return this;
    }

    public StringGrabber removeTailConsecutiveChars(char charToRemove) {
        boolean loop = true;
        if (this.sb.length() > 0) {
            while (loop) {
                if (this.sb.charAt(this.sb.length() - 1) == charToRemove) {
                    this.removeTail(1);
                    continue;
                }
                loop = false;
            }
        }
        return this;
    }

    public StringGrabber removeHeadAndTailChars(char charToRemove) {
        this.removeHeadConsecutiveChars(charToRemove);
        this.removeTailConsecutiveChars(charToRemove);
        return this;
    }

    public StringGrabber toLowerCase() {
        this.set(this.sb.toString().toLowerCase());
        return this;
    }

    public StringGrabber toUpperCase() {
        this.set(this.sb.toString().toUpperCase());
        return this;
    }

    public StringGrabber replaceFirstToLowerCase() {
        return this.replaceToLowerCase(0);
    }

    public StringGrabber replaceToLowerCase(int pos) {
        return this.replaceCaseTo(pos, pos + 1, ECase.LOWER);
    }

    public StringGrabber replaceToLowerCase(int startPos, int endPos) {
        return this.replaceCaseTo(startPos, endPos, ECase.LOWER);
    }

    public StringGrabber replaceFirstToUpperCase() {
        return this.replaceToUpperCase(0);
    }

    public StringGrabber replaceToUpperCase(int pos) {
        return this.replaceCaseTo(pos, pos + 1, ECase.UPPER);
    }

    public StringGrabber replaceToUpperCase(int startPos, int endPos) {
        return this.replaceCaseTo(startPos, endPos, ECase.UPPER);
    }

    public StringGrabber insertIntoHead(String str) {
        if (str != null) {
            try {
                this.sb.insert(0, str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    private StringGrabber replaceCaseTo(int startPos, int endPos, ECase toCase) {
        StringBuilder sbRange = new StringBuilder();
        try {
            for (int i = startPos; i < endPos; ++i) {
                sbRange.append(String.valueOf(this.sb.charAt(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String caseConvertedRangeStr = ECase.LOWER == toCase ? sbRange.toString().toLowerCase() : sbRange.toString().toUpperCase();
        try {
            this.sb.replace(startPos, endPos, caseConvertedRangeStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public StringGrabber left(int charCount) {
        String str = this.getCropper().getLeftOf(this.sb.toString(), charCount);
        this.sb = new StringBuilder(str);
        return this;
    }

    public StringGrabber right(int charCount) {
        String str = this.getCropper().getRightOf(this.sb.toString(), charCount);
        this.sb = new StringBuilder(str);
        return this;
    }

    public StringGrabber replace(String target, String replacement) {
        this.sb = new StringBuilder(this.sb.toString().replace(target, replacement));
        return this;
    }

    public StringGrabber replaceEnclosedIn(String startToken, String endToken, String replacement) {
        StringCropper cropper = this.getCropper();
        List<StringCropper.StrPosition> stringEnclosedInWithDetails = cropper.getStringEnclosedInWithDetails(this.sb.toString(), startToken, endToken);
        ArrayList<Integer> splitList = new ArrayList<Integer>();
        for (StringCropper.StrPosition sp : stringEnclosedInWithDetails) {
            int splitPointFirst = sp.startIndex - 1;
            int splitPointSecond = sp.endIndex;
            splitList.add(splitPointFirst);
            splitList.add(splitPointSecond);
        }
        Integer[] splitIndexes = splitList.toArray(new Integer[0]);
        List<String> splitStringList = cropper.splitByIndex(this.sb.toString(), splitIndexes);
        StringBuilder tempSb = new StringBuilder();
        int strNum = splitStringList.size();
        boolean nextIsValue = false;
        int countOfReplacement = 0;
        for (int i = 0; i < strNum; ++i) {
            String strPart = splitStringList.get(i);
            if (nextIsValue) {
                tempSb.append(replacement);
                ++countOfReplacement;
                if (strPart.startsWith(endToken)) {
                    tempSb.append(strPart);
                }
            } else {
                tempSb.append(strPart);
            }
            nextIsValue = strPart.endsWith(startToken);
        }
        this.sb = tempSb;
        return this;
    }

    public StringGrabber substring(int startIdx, int endIndex) {
        if (startIdx < 0) {
            startIdx = 0;
        }
        if (endIndex > this.length() - 1) {
            endIndex = this.length() - 1;
        }
        this.sb = new StringBuilder(this.substringInternally(startIdx, endIndex));
        return this;
    }

    private String substringInternally(int startIdx, int endIndex) {
        return this.sb.toString().substring(startIdx, endIndex + 1);
    }

    public int length() {
        return this.sb.length();
    }

    public StringGrabber getLastPartsSeparatedBy(String separator) {
        String str = this.sb.toString();
        int idx = str.lastIndexOf(separator);
        this.removeHead(idx + 1);
        return this;
    }

    public int toInt(int defaultValue) {
        try {
            return Integer.parseInt(this.sb.toString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public double toDouble(double defaultValue) {
        try {
            return Double.parseDouble(this.sb.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public float toFloat(float defaultValue) {
        try {
            return Float.parseFloat(this.sb.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public boolean toBoolean(boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.sb.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public StringGrabber appendRepeat(String str, int repeatCount) {
        for (int i = 0; i < repeatCount; ++i) {
            if (str == null) continue;
            this.sb.append(str);
        }
        return this;
    }

    public StringGrabber insertRepeat(String str, int repeatCount) {
        for (int i = 0; i < repeatCount; ++i) {
            this.insertIntoHead(str);
        }
        return this;
    }

    public StringGrabber carryHead(int charCount) {
        this.removeTail(this.length() - charCount);
        return this;
    }

    public StringGrabber carryTail(int charCount) {
        this.removeHead(this.length() - charCount);
        return this;
    }

    public boolean isEmpty() {
        return this.sb.toString().isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.sb.toString().isEmpty();
    }

    public StringGrabber getStringEnclosedInFirst(String startToken, String endToken) {
        return new StringGrabber(this.getCropper().getStringEnclosedInFirst(this.sb.toString(), startToken, endToken));
    }

    public StringGrabberList getStringEnclosedIn(String startToken, String endToken) {
        return new StringGrabberList(this.getCropper().getStringEnclosedIn(this.sb.toString(), startToken, endToken));
    }

    public StringGrabberList split(String regexp) {
        String[] splitedStrings;
        StringGrabberList retList = new StringGrabberList();
        String string = this.sb.toString();
        for (String str : splitedStrings = string.split(regexp)) {
            retList.add(new StringGrabber(str));
        }
        return retList;
    }

    public StringGrabberList toSgList() {
        return this.toSgList(sNewLine);
    }

    private StringGrabberList toSgList(String newLineChars) {
        return this.split(newLineChars);
    }

    public StringGrabber newLine() {
        this.append(sNewLine);
        return this;
    }

    public boolean equals(StringGrabber sg) {
        return sg.toString().equals(this.sb.toString());
    }

    private StringCropper getCropper() {
        if (this.cropper == null) {
            this.cropper = new StringCropper();
        }
        return this.cropper;
    }

    public String toString() {
        return this.sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ECase {
        UPPER,
        LOWER;

    }
}

