/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.wcs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.watson.developer_cloud.conversation.v1.ConversationService;
import com.ibm.watson.developer_cloud.conversation.v1.model.MessageRequest;
import com.ibm.watson.developer_cloud.conversation.v1.model.MessageResponse;
import java.util.Map;

public class WcsClientWrapper {
    private static final String WCS_VERSION = "2017-02-03";
    private final Gson mGson = new GsonBuilder().create();
    private final ConversationService mWcsService;
    private final String mWorkspaceId;

    WcsClientWrapper(String userName, String password, String workspaceId) {
        this.mWorkspaceId = workspaceId;
        this.mWcsService = new ConversationService(WCS_VERSION);
        this.mWcsService.setUsernameAndPassword(userName, password);
    }

    MessageResponse sendMessage(String text, String contextAsJSON) {
        Map context = this.fromJSON(contextAsJSON, Map.class);
        return this.sendMessage(text, context);
    }

    MessageResponse sendMessage(String text, Map<String, Object> context) {
        MessageRequest newMessage = context != null ? new MessageRequest.Builder().inputText(text).context(context).build() : new MessageRequest.Builder().inputText(text).build();
        MessageResponse response = (MessageResponse)this.mWcsService.message(this.mWorkspaceId, newMessage).execute();
        return response;
    }

    public String getJSONFromResponse(MessageResponse response) {
        return response.toString();
    }

    public String getContextJSONFromResponse(MessageResponse response) {
        Map context = response.getContext();
        String json = this.toJSON(context);
        return json;
    }

    private <T> T fromJSON(String json, Class<T> clazz) {
        return (T)this.mGson.fromJson(json, clazz);
    }

    private <T> String toJSON(T clazz) {
        return this.mGson.toJson(clazz);
    }
}

