/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.wcs;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class WcsUserContext
implements Serializable {
    private static final long serialVersionUID = 860289915194669609L;
    private final Map<String, Object> mContext;
    private final Map<String, Object> mAttributes;

    public WcsUserContext(Map<String, Object> context) {
        this.mContext = context;
        this.mAttributes = new HashMap<String, Object>();
    }

    public WcsUserContext(Map<String, Object> context, Map<String, Object> attributes) {
        this.mContext = context;
        this.mAttributes = new HashMap<String, Object>();
    }

    public WcsUserContext put(String key, Object value) {
        this.mContext.put(key, value);
        return this;
    }

    public String getAsString(String key) {
        return (String)this.mContext.get(key);
    }

    public Boolean getAsBoolean(String key) {
        try {
            Boolean booleanObj = (Boolean)this.mContext.get(key);
            return booleanObj;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Integer getAsInteger(String key) {
        try {
            Object o = this.mContext.get(key);
            if (o == null) {
                return null;
            }
            if (o instanceof Double) {
                Integer intValue = (int)((Double)o).doubleValue();
                return intValue;
            }
            if (o instanceof Integer) {
                Integer integerObj = (Integer)o;
                return integerObj;
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Double getAsDouble(String key) {
        try {
            Object o = this.mContext.get(key);
            if (o == null) {
                return null;
            }
            if (o instanceof Double) {
                Double doubleValue = (Double)o;
                return doubleValue;
            }
            if (o instanceof Integer) {
                Double doubleObj = (double)((Integer)o);
                return doubleObj;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Object get(String key) {
        return this.mContext.get(key);
    }

    public WcsUserContext remove(String key) {
        this.mContext.remove(key);
        return this;
    }

    public Map<String, Object> getMap() {
        return this.mContext;
    }

    public Map<String, Object> getLocalAttributes() {
        return this.mAttributes;
    }
}

