/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.http;

import java.net.CookieHandler;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.JavaNetCookieJar;

public final class WatsonCookieJar
implements CookieJar {
    private static final String SESSIONID = "SESSIONID";
    private static final String SESSIONS = "sessions";
    private static final String SPEECH_TO_TEXT = "speech-to-text";
    private JavaNetCookieJar adapter;

    public WatsonCookieJar(CookieHandler cookieHandler) {
        this.adapter = new JavaNetCookieJar(cookieHandler);
    }

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        this.adapter.saveFromResponse(url, cookies);
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<Cookie> cookies = this.adapter.loadForRequest(url);
        if (url.encodedPathSegments().contains(SPEECH_TO_TEXT) && !url.encodedPathSegments().contains(SESSIONS)) {
            ArrayList<Cookie> sessionLessCookies = new ArrayList<Cookie>();
            for (Cookie cookie : cookies) {
                if (cookie.name().equalsIgnoreCase(SESSIONID)) continue;
                sessionLessCookies.add(cookie);
            }
            cookies = sessionLessCookies;
        }
        return cookies;
    }
}

