/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.service;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.http.ServiceCallback;
import com.ibm.watson.developer_cloud.service.exception.BadRequestException;
import com.ibm.watson.developer_cloud.service.exception.ConflictException;
import com.ibm.watson.developer_cloud.service.exception.ForbiddenException;
import com.ibm.watson.developer_cloud.service.exception.InternalServerErrorException;
import com.ibm.watson.developer_cloud.service.exception.NotFoundException;
import com.ibm.watson.developer_cloud.service.exception.RequestTooLargeException;
import com.ibm.watson.developer_cloud.service.exception.ServiceResponseException;
import com.ibm.watson.developer_cloud.service.exception.ServiceUnavailableException;
import com.ibm.watson.developer_cloud.service.exception.TooManyRequestsException;
import com.ibm.watson.developer_cloud.service.exception.UnauthorizedException;
import com.ibm.watson.developer_cloud.service.exception.UnsupportedException;
import com.ibm.watson.developer_cloud.service.security.DelegatingSSLSocketFactory;
import com.ibm.watson.developer_cloud.service.security.MisawaTokenManager;
import com.ibm.watson.developer_cloud.util.CredentialUtils;
import com.ibm.watson.developer_cloud.util.HttpLogging;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseUtils;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import jersey.repackaged.jsr166e.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.TlsVersion;

public abstract class WatsonService {
    private MisawaTokenManager mTokenManager = null;
    private static final String URL = "url";
    private static final String PATH_AUTHORIZATION_V1_TOKEN = "/v1/token";
    private static final String AUTHORIZATION = "authorization";
    private static final String MESSAGE_ERROR_3 = "message";
    private static final String MESSAGE_ERROR_2 = "error_message";
    private static final String BASIC = "Basic ";
    private static final Logger LOG = Logger.getLogger(WatsonService.class.getName());
    private String apiKey;
    private final OkHttpClient client;
    private String endPoint;
    private final String name;
    protected Headers defaultHeaders = null;
    protected boolean skipAuthentication = false;
    protected static final String MESSAGE_CODE = "code";
    protected static final String MESSAGE_ERROR = "error";
    protected static final String VERSION = "version";
    private static final String BEARER = "Bearer ";
    protected static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/((json)|(merge\\-patch\\+json))(;.*)?");
    protected static final Pattern JSON_PATCH_MIME_PATTERN = Pattern.compile("(?i)application\\/json\\-patch\\+json(;.*)?");

    public WatsonService(String name) {
        this.name = name;
        this.apiKey = CredentialUtils.getAPIKey((String)name);
        this.client = this.configureHttpClient();
        String url = CredentialUtils.getAPIUrl((String)name);
        if (url != null && !url.isEmpty()) {
            this.setEndPoint(url);
        }
    }

    protected OkHttpClient configureHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        builder.cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager));
        builder.connectTimeout(60L, TimeUnit.SECONDS);
        builder.writeTimeout(60L, TimeUnit.SECONDS);
        builder.readTimeout(90L, TimeUnit.SECONDS);
        builder.addNetworkInterceptor((Interceptor)HttpLogging.getLoggingInterceptor());
        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledCipherSuites().build();
        builder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
        this.setupTLSProtocol(builder);
        return builder.build();
    }

    private void setupTLSProtocol(OkHttpClient.Builder builder) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            DelegatingSSLSocketFactory sslSocketFactory = new DelegatingSSLSocketFactory(sslContext.getSocketFactory()){

                protected SSLSocket configureSocket(SSLSocket socket) throws IOException {
                    socket.setEnabledProtocols(new String[]{TlsVersion.TLS_1_0.javaName(), TlsVersion.TLS_1_1.javaName(), TlsVersion.TLS_1_2.javaName()});
                    return socket;
                }
            };
            builder.sslSocketFactory((SSLSocketFactory)sslSocketFactory, trustManager);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.SEVERE, "The cryptographic algorithm requested is not available in the environment.", e);
        }
        catch (KeyStoreException e) {
            LOG.log(Level.SEVERE, "Error using the keystore.", e);
        }
        catch (KeyManagementException e) {
            LOG.log(Level.SEVERE, "Error initializing the SSL Context.", e);
        }
    }

    private Call createCall(Request request) {
        Request.Builder builder = request.newBuilder();
        if (RequestUtils.isRelative((Request)request)) {
            builder.url(RequestUtils.replaceEndPoint((String)request.url().toString(), (String)this.getEndPoint()));
        }
        String userAgent = RequestUtils.getUserAgent();
        if (this.defaultHeaders != null) {
            for (String key : this.defaultHeaders.names()) {
                builder.header(key, this.defaultHeaders.get(key));
            }
            if (this.defaultHeaders.get("User-Agent") != null) {
                userAgent = userAgent + " " + this.defaultHeaders.get("User-Agent");
            }
        }
        builder.header("User-Agent", userAgent);
        this.setAuthentication(builder);
        Request newRequest = builder.build();
        return this.client.newCall(newRequest);
    }

    protected final <T> ServiceCall<T> createServiceCall(Request request, final ResponseConverter<T> converter) {
        final Call call = this.createCall(request);
        return new ServiceCall<T>(){

            public T execute() {
                try {
                    Response response = call.execute();
                    return WatsonService.this.processServiceCall(converter, response);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void enqueue(final ServiceCallback<? super T> callback) {
                call.enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        callback.onFailure((Exception)e);
                    }

                    public void onResponse(Call call, Response response) {
                        try {
                            callback.onResponse(WatsonService.this.processServiceCall(converter, response));
                        }
                        catch (Exception e) {
                            callback.onFailure(e);
                        }
                    }
                });
            }

            public CompletableFuture<T> rx() {
                final CompletableFuture completableFuture = new CompletableFuture();
                call.enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        completableFuture.completeExceptionally((Throwable)e);
                    }

                    public void onResponse(Call call, Response response) {
                        try {
                            completableFuture.complete(WatsonService.this.processServiceCall(converter, response));
                        }
                        catch (Exception e) {
                            completableFuture.completeExceptionally((Throwable)e);
                        }
                    }
                });
                return completableFuture;
            }

            protected void finalize() throws Throwable {
                super.finalize();
                if (!call.isExecuted()) {
                    Request r = call.request();
                    LOG.warning(r.method() + " request to " + r.url() + " has not been sent. Did you forget to call execute()?");
                }
            }
        };
    }

    protected String getApiKey() {
        return this.apiKey;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    private String getErrorMessage(Response response) {
        String error = ResponseUtils.getString(response);
        try {
            JsonObject jsonObject = ResponseUtils.getJsonObject(error);
            if (jsonObject.has(MESSAGE_ERROR)) {
                error = jsonObject.get(MESSAGE_ERROR).getAsString();
            } else if (jsonObject.has(MESSAGE_ERROR_2)) {
                error = jsonObject.get(MESSAGE_ERROR_2).getAsString();
            } else if (jsonObject.has(MESSAGE_ERROR_3)) {
                error = jsonObject.get(MESSAGE_ERROR_3).getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return error;
    }

    public String getName() {
        return this.name;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
        this.mTokenManager = new MisawaTokenManager(apiKey);
    }

    protected void setAuthenticationOld(Request.Builder builder) {
        if (this.getApiKey() == null) {
            if (this.skipAuthentication) {
                return;
            }
            throw new IllegalArgumentException("apiKey or username and password were not specified");
        }
        builder.addHeader("Authorization", this.apiKey.startsWith(BASIC) ? this.apiKey : BASIC + this.apiKey);
    }

    protected void setAuthentication(Request.Builder builder) {
        if (this.mTokenManager != null) {
            String accessToken = this.mTokenManager.getToken();
            builder.addHeader("Authorization", BEARER + accessToken);
        } else {
            if (this.getApiKey() == null) {
                if (this.skipAuthentication) {
                    Headers currentHeaders = builder.build().headers();
                    if (currentHeaders.get("X-Watson-Authorization-Token") != null) {
                        // empty if block
                    }
                    return;
                }
                throw new IllegalArgumentException("apiKey or username and password were not specified");
            }
            builder.addHeader("Authorization", this.apiKey.startsWith(BASIC) ? this.apiKey : BASIC + this.apiKey);
        }
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint != null && !endPoint.isEmpty() && endPoint.endsWith("/") ? endPoint.substring(0, endPoint.length() - 1) : endPoint;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.apiKey = Credentials.basic((String)username, (String)password);
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        this.defaultHeaders = headers == null ? null : Headers.of(headers);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.name).append(" [");
        if (this.endPoint != null) {
            builder.append("endPoint=").append(this.endPoint);
        }
        return builder.append(']').toString();
    }

    protected <T> T processServiceCall(ResponseConverter<T> converter, Response response) {
        if (response.isSuccessful()) {
            return (T)converter.convert(response);
        }
        String error = this.getErrorMessage(response);
        LOG.log(Level.SEVERE, response.request().method() + " " + response.request().url().toString() + ", status: " + response.code() + ", error: " + error);
        switch (response.code()) {
            case 400: {
                throw new BadRequestException(error != null ? error : "Bad Request", response);
            }
            case 401: {
                throw new UnauthorizedException("Unauthorized: Access is denied due to invalid credentials", response);
            }
            case 403: {
                throw new ForbiddenException(error != null ? error : "Forbidden: Service refuse the request", response);
            }
            case 404: {
                throw new NotFoundException(error != null ? error : "Not found", response);
            }
            case 406: {
                throw new ForbiddenException(error != null ? error : "Forbidden: Service refuse the request", response);
            }
            case 409: {
                throw new ConflictException(error != null ? error : "", response);
            }
            case 413: {
                throw new RequestTooLargeException(error != null ? error : "Request too large: The request entity is larger than the server is able to process", response);
            }
            case 415: {
                throw new UnsupportedException(error != null ? error : "Unsupported Media Type", response);
            }
            case 429: {
                throw new TooManyRequestsException(error != null ? error : "Too many requests", response);
            }
            case 500: {
                throw new InternalServerErrorException(error != null ? error : "Internal Server Error", response);
            }
            case 503: {
                throw new ServiceUnavailableException(error != null ? error : "Service Unavailable", response);
            }
        }
        throw new ServiceResponseException(response.code(), error, response);
    }

    public void setSkipAuthentication(boolean skipAuthentication) {
        this.skipAuthentication = skipAuthentication;
    }

    public static boolean isJsonMimeType(String mimeType) {
        return mimeType != null && JSON_MIME_PATTERN.matcher(mimeType).matches();
    }

    public static boolean isJsonPatchMimeType(String mimeType) {
        return mimeType != null && JSON_PATCH_MIME_PATTERN.matcher(mimeType).matches();
    }
}

