/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.wcs;

import com.ibm.watson.developer_cloud.conversation.v1.model.MessageResponse;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import org.riversun.wcs.WcsClientUserContextManager;
import org.riversun.wcs.WcsClientWrapper;
import org.riversun.wcs.WcsContextCache;
import org.riversun.wcs.WcsUserContext;

public class WcsClient {
    private final WcsClientWrapper mWcsWrapper;
    private final WcsClientUserContextManager mCtxMgr;
    private boolean mWelcomeNodeResponseEnabled = false;
    private String mResponseTextSeparator = "\n";

    public WcsClient(String userName, String password, String workspaceId) {
        this.mWcsWrapper = new WcsClientWrapper(userName, password, workspaceId);
        this.mCtxMgr = new WcsClientUserContextManager();
        this.setLibLoggingEnabled(false);
    }

    public WcsClient(String userName, String password, String workspaceId, WcsContextCache contextCacheImpl) {
        this.mWcsWrapper = new WcsClientWrapper(userName, password, workspaceId);
        this.mCtxMgr = new WcsClientUserContextManager(contextCacheImpl);
        this.setLibLoggingEnabled(false);
    }

    public WcsClient(WcsClientWrapper.WatsonCredential cred, String workspaceId) {
        this.mWcsWrapper = new WcsClientWrapper(cred, workspaceId);
        this.mCtxMgr = new WcsClientUserContextManager();
        this.setLibLoggingEnabled(false);
    }

    public synchronized boolean isConversationStarted(String wcsClientId) {
        return this.mCtxMgr.hasUser(wcsClientId);
    }

    public synchronized MessageResponse startConversation(String wcsClientId) {
        return this.sendMessage(wcsClientId, "");
    }

    public synchronized MessageResponse callWelcomeNodeIfNeeded(String wcsClientId) {
        if (this.isConversationStarted(wcsClientId)) {
            return null;
        }
        return this.sendMessage(wcsClientId, "");
    }

    public synchronized void clearConversation(String wcsClientId) {
        this.mCtxMgr.clearConversation(wcsClientId);
    }

    public synchronized MessageResponse sendMessage(String wcsClientId, String text) {
        if (this.mCtxMgr.hasUser(wcsClientId)) {
            Map<String, Object> context = this.getUserContext(wcsClientId).getMap();
            MessageResponse watsonMessageResponse = this.mWcsWrapper.sendMessage(text, context);
            this.mCtxMgr.updateUserContext(wcsClientId, watsonMessageResponse);
            return watsonMessageResponse;
        }
        MessageResponse firstResponse = this.mWcsWrapper.sendMessage(text, (Map<String, Object>)null);
        Map context = firstResponse.getContext();
        WcsUserContext userContext = new WcsUserContext(context);
        this.mCtxMgr.populateToUserContext(wcsClientId, userContext);
        return firstResponse;
    }

    public void setWelcomeNodeResponseEnabled(boolean enabled) {
        this.mWelcomeNodeResponseEnabled = enabled;
    }

    public void setResponseTextSeparator(String responseTextNewLine) {
        this.mResponseTextSeparator = responseTextNewLine;
    }

    public String sendMessageForText(String wcsClientId, String userInputText) {
        StringBuilder watsonOutputText = new StringBuilder();
        if (!this.isConversationStarted(wcsClientId)) {
            MessageResponse wcsWelcomeRes = this.startConversation(wcsClientId);
            if (this.mWelcomeNodeResponseEnabled) {
                watsonOutputText.append(this.join(this.mResponseTextSeparator, wcsWelcomeRes.getText())).append(this.mResponseTextSeparator);
            }
        }
        MessageResponse wcsRes = this.sendMessage(wcsClientId, userInputText);
        watsonOutputText.append(this.join(this.mResponseTextSeparator, wcsRes.getText()));
        return watsonOutputText.toString();
    }

    private WcsUserContext getUserContext(String wcsClientId) {
        return this.mCtxMgr.getUserContext(wcsClientId);
    }

    public void put(String wcsClientId, String key, Object value) {
        WcsUserContext context = this.getUserContext(wcsClientId);
        context.put(key, value);
    }

    public String getAsString(String wcsClientId, String key) {
        WcsUserContext context = this.getUserContext(wcsClientId);
        return context.getAsString(key);
    }

    public Boolean getAsBoolean(String wcsClientId, String key) {
        WcsUserContext context = this.getUserContext(wcsClientId);
        return context.getAsBoolean(key);
    }

    public Integer getAsInteger(String wcsClientId, String key) {
        WcsUserContext context = this.getUserContext(wcsClientId);
        return context.getAsInteger(key);
    }

    public Double getAsDouble(String wcsClientId, String key) {
        WcsUserContext context = this.getUserContext(wcsClientId);
        return context.getAsDouble(key);
    }

    public Map<String, Object> getAsMap(String wcsClientId, String key) {
        WcsUserContext context = this.getUserContext(wcsClientId);
        try {
            return (Map)context.get(key);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void setLibLoggingEnabled(boolean enabled) {
        Logger libLogger = Logger.getLogger(OkHttpClient.class.getName());
        libLogger.setUseParentHandlers(enabled);
    }

    private String join(String separator, List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String str : list) {
            if (str.length() <= 0) continue;
            sb.append(str);
            sb.append(separator);
        }
        return sb.toString();
    }

    public WcsClientWrapper getDialogManager() {
        return this.mWcsWrapper;
    }

    public synchronized String getTextFrom(MessageResponse messageResponse) {
        StringBuilder sb = new StringBuilder();
        List list = messageResponse.getText();
        for (String str : list) {
            sb.append(str);
            sb.append("\n");
        }
        return sb.toString();
    }
}

