/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.wcs;

import com.ibm.watson.developer_cloud.conversation.v1.model.MessageResponse;
import org.riversun.wcs.WcsContextCache;
import org.riversun.wcs.WcsContextCacheDefaultImpl;
import org.riversun.wcs.WcsUserContext;

public class WcsClientUserContextManager {
    private final WcsContextCache mContextCacheImpl;

    WcsClientUserContextManager() {
        this.mContextCacheImpl = new WcsContextCacheDefaultImpl();
    }

    WcsClientUserContextManager(WcsContextCache contextCacheImpl) {
        this.mContextCacheImpl = contextCacheImpl;
    }

    boolean hasUser(String wcsClientId) {
        return this.mContextCacheImpl.hasId(wcsClientId);
    }

    void clearConversation(String wcsClientId) {
        if (this.hasUser(wcsClientId)) {
            this.mContextCacheImpl.remove(wcsClientId);
        }
    }

    WcsClientUserContextManager updateUserContext(String user, MessageResponse response) {
        this.populateToUserContext(user, new WcsUserContext(response.getContext()));
        return this;
    }

    WcsClientUserContextManager populateToUserContext(String wcsClientId, WcsUserContext ctx) {
        if (this.mContextCacheImpl.hasId(wcsClientId)) {
            WcsUserContext crrCtx = this.mContextCacheImpl.get(wcsClientId);
            crrCtx.getMap().putAll(ctx.getMap());
            crrCtx.getLocalAttributes().putAll(ctx.getLocalAttributes());
        } else {
            this.mContextCacheImpl.put(wcsClientId, ctx);
        }
        return this;
    }

    WcsUserContext getUserContext(String wcsClientId) {
        if (this.hasUser(wcsClientId)) {
            return this.mContextCacheImpl.get(wcsClientId);
        }
        return null;
    }
}

