/*
 * Decompiled with CFR 0.152.
 */
package org.robobinding.supportwidget.recyclerview;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import org.robobinding.BindableView;
import org.robobinding.itempresentationmodel.ItemContext;
import org.robobinding.itempresentationmodel.RefreshableItemPresentationModel;
import org.robobinding.presentationmodel.AbstractPresentationModelObject;
import org.robobinding.property.DataSetValueModel;
import org.robobinding.viewattribute.ViewTag;
import org.robobinding.viewattribute.ViewTags;
import org.robobinding.widget.adapterview.ItemLayoutBinder;
import org.robobinding.widget.adapterview.ItemLayoutSelector;

public class DataSetAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final DataSetValueModel dataSetValueModel;
    private final ItemLayoutBinder itemLayoutBinder;
    private final ItemLayoutSelector layoutSelector;
    private final ViewTags<RefreshableItemPresentationModel> viewTags;
    private final boolean preInitializeViews;

    public DataSetAdapter(DataSetValueModel dataSetValueModel, ItemLayoutBinder itemLayoutBinder, ItemLayoutSelector layoutSelector, ViewTags<RefreshableItemPresentationModel> viewTags, boolean preInitializeViews) {
        this.preInitializeViews = preInitializeViews;
        this.dataSetValueModel = dataSetValueModel;
        this.itemLayoutBinder = itemLayoutBinder;
        this.layoutSelector = layoutSelector;
        this.viewTags = viewTags;
    }

    public int getItemCount() {
        return this.dataSetValueModel.size();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        int layoutId = this.layoutSelector.selectLayout(viewType);
        BindableView bindableView = this.itemLayoutBinder.inflate(parent, layoutId);
        View view = bindableView.getRootView();
        RefreshableItemPresentationModel itemPresentationModel = this.dataSetValueModel.newRefreshableItemPresentationModel(viewType);
        ViewTag viewTag = this.viewTags.tagFor(view);
        viewTag.set((Object)itemPresentationModel);
        return new ViewHolder(view, bindableView, (AbstractPresentationModelObject)itemPresentationModel);
    }

    public void onBindViewHolder(ViewHolder viewHolder, int position) {
        View view = viewHolder.itemView;
        ViewTag viewTag = this.viewTags.tagFor(view);
        RefreshableItemPresentationModel itemPresentationModel = (RefreshableItemPresentationModel)viewTag.get();
        itemPresentationModel.updateData(this.getItem(position), new ItemContext(view, position));
        if (viewHolder.isNewView()) {
            viewHolder.bindView();
        } else {
            this.refreshIfRequired(itemPresentationModel);
        }
    }

    private void refreshIfRequired(RefreshableItemPresentationModel itemPresentationModel) {
        if (this.preInitializeViews) {
            itemPresentationModel.refresh();
        }
    }

    private Object getItem(int position) {
        return this.dataSetValueModel.get(position);
    }

    public int getItemViewType(int position) {
        return this.layoutSelector.getItemViewType(this.getItem(position), position);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private final BindableView bindableView;
        private final AbstractPresentationModelObject itemPresentationModel;
        private boolean notBound;

        public ViewHolder(View view, BindableView bindableView, AbstractPresentationModelObject itemPresentationModel) {
            super(view);
            this.bindableView = bindableView;
            this.itemPresentationModel = itemPresentationModel;
            this.notBound = true;
        }

        private boolean isNewView() {
            return this.notBound;
        }

        private void bindView() {
            if (this.notBound) {
                this.bindableView.bindTo(this.itemPresentationModel);
                this.notBound = false;
            }
        }
    }
}

