/*
 * Decompiled with CFR 0.152.
 */
package org.robobinding.supportwidget.recyclerview;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.robobinding.BindingContext;
import org.robobinding.ItemBinder;
import org.robobinding.PredefinedPendingAttributesForView;
import org.robobinding.itempresentationmodel.RefreshableItemPresentationModel;
import org.robobinding.itempresentationmodel.ViewTypeSelectable;
import org.robobinding.property.DataSetPropertyChangeListener;
import org.robobinding.property.DataSetValueModel;
import org.robobinding.supportwidget.recyclerview.DataSetAdapter;
import org.robobinding.supportwidget.recyclerview.DataSetPropertyChangeListenerAdapter;
import org.robobinding.viewattribute.ViewTags;
import org.robobinding.widget.adapterview.ItemLayoutBinder;
import org.robobinding.widget.adapterview.ItemLayoutSelector;
import org.robobinding.widget.adapterview.ItemLayoutUpdater;
import org.robobinding.widget.adapterview.ItemLayoutsUpdater;
import org.robobinding.widget.adapterview.ItemMappingUpdater;
import org.robobinding.widget.adapterview.LazyDataSetValueModel;
import org.robobinding.widget.adapterview.MultiItemLayoutSelector;
import org.robobinding.widget.adapterview.SingleItemLayoutSelector;
import org.robobinding.widget.adapterview.SourceAttribute;

public class DataSetAdapterBuilder
implements SourceAttribute.RequiresDataSetValueModel,
ItemLayoutUpdater.RequiresItemLayoutId,
ItemLayoutsUpdater.RequiresItemLayoutIds,
ItemMappingUpdater.RequiresItemPredefinedMappings {
    private static final int ITEM_PRESENTATION_MODEL_KEY = 1;
    private final BindingContext bindingContext;
    private List<Integer> itemLayoutIds;
    private Collection<PredefinedPendingAttributesForView> itemPredefinedMappings;
    private DataSetValueModel valueModel;
    private DataSetPropertyChangeListener oldListener;

    public DataSetAdapterBuilder(BindingContext bindingContext) {
        this.bindingContext = bindingContext;
        this.itemLayoutIds = Collections.emptyList();
        this.itemPredefinedMappings = Collections.emptyList();
    }

    public void setItemLayoutId(int itemLayoutId) {
        this.setItemLayoutIds(Lists.newArrayList((Object[])new Integer[]{itemLayoutId}));
    }

    public void setItemLayoutIds(List<Integer> itemLayoutIds) {
        this.itemLayoutIds = itemLayoutIds;
    }

    public void setItemPredefinedMappings(Collection<PredefinedPendingAttributesForView> itemPredefinedMappings) {
        if (itemPredefinedMappings != null) {
            this.itemPredefinedMappings = itemPredefinedMappings;
        }
    }

    public void setValueModel(DataSetValueModel valueModel) {
        this.valueModel = valueModel;
    }

    public DataSetAdapter build() {
        ItemBinder itemBinder = this.bindingContext.createItemBinder();
        ItemLayoutBinder itemLayoutBinder = new ItemLayoutBinder(itemBinder, this.itemPredefinedMappings);
        ItemLayoutSelector itemLayoutSelector = this.buildItemLayoutSelector();
        DataSetAdapter dataSetAdapter = new DataSetAdapter(this.valueModelWithPreInitializeViews(this.valueModel, this.bindingContext.shouldPreInitializeViews()), itemLayoutBinder, itemLayoutSelector, (ViewTags<RefreshableItemPresentationModel>)new ViewTags(1), this.bindingContext.shouldPreInitializeViews());
        this.registerPropertyChangeListener(dataSetAdapter);
        return dataSetAdapter;
    }

    private ItemLayoutSelector buildItemLayoutSelector() {
        if (this.isSingleItemLayout()) {
            return new SingleItemLayoutSelector(this.itemLayoutIds.get(0).intValue());
        }
        return new MultiItemLayoutSelector(this.itemLayoutIds, (ViewTypeSelectable)this.valueModel);
    }

    private boolean isSingleItemLayout() {
        return this.itemLayoutIds.size() == 1;
    }

    private DataSetValueModel valueModelWithPreInitializeViews(DataSetValueModel valueModel, boolean preInitializeViews) {
        if (preInitializeViews) {
            return valueModel;
        }
        return new LazyDataSetValueModel(valueModel);
    }

    private void registerPropertyChangeListener(DataSetAdapter dataSetAdapter) {
        this.valueModel.removePropertyChangeListener(this.oldListener);
        DataSetPropertyChangeListenerAdapter listener = new DataSetPropertyChangeListenerAdapter(dataSetAdapter);
        this.valueModel.addPropertyChangeListener((DataSetPropertyChangeListener)listener);
        this.oldListener = listener;
    }
}

