/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.compiled.CompiledPath;
import org.robokind.api.common.utils.Utils;

public class Channel {
    private List<MotionPath> myPaths = new ArrayList<MotionPath>();
    private int myId;
    private String myName;
    private Long myStartTime;
    private Long myStopTime;

    public Channel(int id, String name) {
        this.myId = id;
        this.myName = name;
    }

    public void setId(int id) {
        this.myId = id;
    }

    public Integer getId() {
        return this.myId;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public void setStartTime(Long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("start time must be positive");
        }
        this.myStartTime = time;
        this.setPathStartTime(time);
    }

    private void setPathStartTime(Long time) {
        for (MotionPath m : this.myPaths) {
            m.setStartTime(time);
        }
    }

    public Long getStartTime() {
        return this.myStartTime;
    }

    public void setStopTime(Long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("start time must be positive");
        }
        this.myStopTime = time;
        this.setPathStopTime(time);
    }

    private void setPathStopTime(Long time) {
        for (MotionPath m : this.myPaths) {
            m.setStopTime(time);
        }
    }

    public Long getStopTime() {
        return this.myStopTime;
    }

    public void addPaths(List<MotionPath> paths) {
        if (paths == null) {
            throw new NullPointerException("Cannot add null MotionPaths.");
        }
        this.myPaths.addAll(paths);
    }

    public void addPath(MotionPath p) {
        if (p == null) {
            throw new NullPointerException("Cannot add null MotionPath.");
        }
        this.myPaths.add(p);
    }

    public void addPath(int i, MotionPath p) {
        if (p == null) {
            throw new NullPointerException("Cannot add null MotionPath.");
        }
        Utils.bound((int)i, (int)0, (int)this.myPaths.size());
        this.myPaths.add(i, p);
    }

    public List<MotionPath> getMotionPaths() {
        return this.myPaths;
    }

    public MotionPath getMotionPath(int i) {
        if (i < -1 || i > this.myPaths.size()) {
            return null;
        }
        return this.myPaths.get(i);
    }

    public MotionPath removeMotionPath(int i) {
        if (i < -1 || i > this.myPaths.size()) {
            return null;
        }
        return this.myPaths.remove(i);
    }

    public int removeMotionPath(MotionPath mp) {
        int i = this.myPaths.indexOf(mp);
        if (i != -1) {
            this.myPaths.remove(i);
        }
        return i;
    }

    public CompiledPath getCompiledPath(long stepLength) {
        long start = this.myStartTime == null ? -1L : this.myStartTime;
        long stop = this.myStopTime == null ? -1L : this.myStopTime;
        return this.compilePath(start, stop, stepLength);
    }

    public CompiledPath compilePath(long start, long end, long stepLength) {
        List<Point2D> points = this.getInterpolatedPoints(start, end);
        if (points.isEmpty()) {
            return null;
        }
        if (start == -1L) {
            start = (long)points.get(0).getX();
        }
        if (end == -1L) {
            end = (long)points.get(points.size() - 1).getX();
        }
        return CompiledPath.compilePath(start, end, points, stepLength);
    }

    public List<Point2D> getInterpolatedPoints(long start, long end) {
        ArrayList<Point2D> paths = new ArrayList<Point2D>();
        for (MotionPath p : this.myPaths) {
            List<Point2D> path = p.getInterpolatedPoints();
            this.combineInterpolations(paths, path);
        }
        int iStart = 0;
        int iEnd = paths.size();
        if (start == -1L && end == -1L) {
            return paths;
        }
        if (start != -1L) {
            for (Point2D p : paths) {
                if (p.getX() >= (double)start) {
                    --iStart;
                    break;
                }
                ++iStart;
            }
            if ((iStart = Math.max(iStart, 0)) > iEnd) {
                return new ArrayList<Point2D>();
            }
        }
        if (end != -1L) {
            ListIterator rit = paths.listIterator(iEnd);
            while (rit.hasPrevious()) {
                Point2D p;
                p = (Point2D)rit.previous();
                if (p.getX() <= (double)end) {
                    ++iEnd;
                    break;
                }
                --iEnd;
            }
            if ((iEnd = Math.min(iEnd, paths.size())) < iStart) {
                return new ArrayList<Point2D>();
            }
        }
        if (iEnd == iStart && iEnd < paths.size()) {
            ++iEnd;
        }
        return paths.subList(iStart, iEnd);
    }

    private void combineInterpolations(List<Point2D> a, List<Point2D> b) {
        Point2D pI;
        Point2D p;
        int iB;
        if (a == null || b == null || b.isEmpty()) {
            return;
        }
        if (a.isEmpty()) {
            a.addAll(b);
            return;
        }
        double min = a.get(0).getX();
        double max = a.get(a.size() - 1).getX();
        int lenB = b.size();
        double x = 0.0;
        for (iB = 0; iB < lenB && !((x = (p = b.get(iB)).getX()) >= min); ++iB) {
        }
        if (iB > 0) {
            a.addAll(0, b.subList(0, iB));
            if (iB < lenB && (pI = this.findInterpolatedValue(b.get(iB - 1), b.get(iB), min - 1.0)) != null) {
                a.add(iB, pI);
            }
        }
        if (iB == lenB && x + 2.0 < min) {
            a.add(iB, new Point2D.Double(x + 1.0, -1.0));
            a.add(iB, new Point2D.Double(min - 1.0, -1.0));
        }
        if (iB == 0 && b.get(0).getX() - 1.0 > max) {
            a.add(new Point2D.Double(max + 1.0, -1.0));
            a.add(new Point2D.Double(x - 1.0, -1.0));
        }
        while (iB < lenB && !((x = (p = b.get(iB)).getX()) > max)) {
            ++iB;
        }
        if (iB < lenB) {
            if (iB > 0 && (pI = this.findInterpolatedValue(b.get(iB - 1), b.get(iB), max + 1.0)) != null) {
                a.add(pI);
            }
            a.addAll(b.subList(iB, lenB));
        }
    }

    private Point2D findInterpolatedValue(Point2D a, Point2D b, double x) {
        double aX = a.getX();
        if (aX >= x) {
            return null;
        }
        double yRange = b.getY() - a.getY();
        double ratio = (x - aX) / (b.getX() - aX);
        double y = ratio * yRange + a.getY();
        return new Point2D.Double(x, y);
    }

    public Channel clone() {
        Channel channel = new Channel(this.myId, this.myName);
        channel.myStartTime = this.myStartTime;
        channel.myStopTime = this.myStopTime;
        for (MotionPath mp : this.myPaths) {
            channel.addPath(mp.clone());
        }
        return channel;
    }
}

