/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.common.utils.Utils;

public class Transforms {
    public static void translatePath(MotionPath src, MotionPath dest, double amtX, double amtY) {
        int min = 0;
        for (int i = 0; i < dest.getControlPoints().size(); ++i) {
            Point2D p = src.getControlPoints().get(i);
            double x = p.getX() + amtX;
            if (x <= (double)min) {
                x = min;
                ++min;
            }
            dest.moveControlPoint(i, x, p.getY() + amtY);
        }
    }

    public static void scalePathTime(MotionPath src, MotionPath dest, double scale, double ref) {
        List<Point2D> points = src.getControlPoints();
        int len = points.size();
        if (scale <= 0.0 || ref < 0.0 || len < 2) {
            return;
        }
        ref = Utils.bound((double)ref, (double)points.get(0).getX(), (double)points.get(len - 1).getX());
        int min = 0;
        for (int i = 0; i < len; ++i) {
            Point2D p = points.get(i);
            double x = (p.getX() - ref) * scale + ref;
            if (x <= (double)min) {
                x = min;
                ++min;
            }
            dest.moveControlPoint(i, x, p.getY());
        }
    }

    public static void setPathControlPoints(MotionPath path, List<Point2D> points) {
        for (int i = 0; i < points.size(); ++i) {
            Point2D p = points.get(i);
            path.moveControlPoint(i, p.getX(), p.getY());
        }
    }

    public static List<Point2D> scaleTimes(List<Point2D> points, double scale, double ref) {
        ArrayList<Point2D> ret = new ArrayList<Point2D>();
        if (scale <= 0.0 || ref < 0.0) {
            return ret;
        }
        int min = 0;
        for (Point2D p : points) {
            double x = (p.getX() - ref) * scale + ref;
            if ((x = Math.max(x, (double)min)) == (double)min) {
                ++min;
            }
            ret.add(new Point2D.Double(x, p.getY()));
        }
        return ret;
    }

    public static List<Point2D> scalePositions(List<Point2D> points, double scale, double ref) {
        ArrayList<Point2D> ret = new ArrayList<Point2D>();
        if (scale <= 0.0 || ref < 0.0 || ref > 1.0) {
            return ret;
        }
        for (Point2D p : points) {
            double y = (p.getY() - ref) * scale + ref;
            y = Utils.bound((double)y, (double)0.0, (double)1.0);
            ret.add(new Point2D.Double(p.getX(), y));
        }
        return ret;
    }

    public static List<Point2D> translatePoints(List<Point2D> points, double amtX, double amtY) {
        ArrayList<Point2D> ret = new ArrayList<Point2D>();
        for (Point2D p : points) {
            ret.add(new Point2D.Double(p.getX() + amtX, p.getY() + amtY));
        }
        return ret;
    }
}

