/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor;

import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.editor.AbstractEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.localization.Localizer;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.common.utils.Source;

public class AnimationEditor
extends AbstractEditor<Channel, ChannelEditor> {
    public static final String PROP_PATH = "Path";
    private Animation myAnimation;
    private String myPath;

    public AnimationEditor(Animation a, String path, HistoryStack hist) {
        super(hist);
        this.myAnimation = a.clone();
        this.myPath = path;
        this.setChildren(this.myAnimation.getChannels());
    }

    public String getFilePath() {
        return this.myPath;
    }

    public void setFilePath(String path) {
        String oldPath = this.myPath;
        this.myPath = path;
        this.firePropertyChange(PROP_PATH, oldPath, this.myPath);
    }

    @Override
    protected void setSelected(int i, boolean sel, HistoryStack hist) {
        if (i < 0 || i >= this.myChildren.size()) {
            return;
        }
        ChannelEditor child = (ChannelEditor)((Object)this.getChild(i));
        if (child == null) {
            return;
        }
        child.setState((Object)this, EditState.SELECTED, sel, hist);
        if (!sel) {
            return;
        }
        if (child.getSelectedIndex() == -1) {
            if (child.getChildren().isEmpty()) {
                return;
            }
            child.select((Object)this, 0, hist);
        }
    }

    @Override
    public String getName() {
        VersionProperty ver = this.myAnimation.getVersion();
        if (ver != null) {
            return ver.display();
        }
        return Localizer.$((String)"new.animation");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        VersionProperty oldVersion = this.myAnimation.getVersion();
        String versionNumber = this.myAnimation.getVersion().getNumber();
        this.myAnimation.setVersion(name, versionNumber);
        this.firePropertyChange("name", oldVersion.display(), this.myAnimation.getVersion().display());
    }

    public void setVersionNumber(String versionNumber) {
        VersionProperty oldVersion = this.myAnimation.getVersion();
        String name = this.myAnimation.getVersion().getName();
        this.myAnimation.setVersion(name, versionNumber);
        this.firePropertyChange("name", oldVersion.display(), this.myAnimation.getVersion().display());
    }

    public VersionProperty getVersion() {
        return this.myAnimation.getVersion();
    }

    public void setVersion(VersionProperty version) {
        if (version == null) {
            return;
        }
        VersionProperty oldVersion = this.myAnimation.getVersion();
        String name = version.getName();
        String ver = version.getNumber();
        if (name == null || name.isEmpty()) {
            name = this.myAnimation.getVersion().getName();
        }
        this.myAnimation.setVersion(name, ver);
        this.firePropertyChange("name", oldVersion.display(), this.myAnimation.getVersion().display());
    }

    @Override
    protected Channel removeChild(Object invoker, int i) {
        return this.myAnimation.removeChannelByListOrder(i);
    }

    public Animation getAnimation() {
        return this.myAnimation.clone();
    }

    public Animation getEnabledAnimation() {
        Animation anim = new Animation();
        for (ChannelEditor cc : this.myChildren) {
            if (cc.hasFlag(EditState.DISABLED)) continue;
            anim.addChannel(cc.getChannelView());
        }
        Animation a = anim.clone();
        for (ServiceAddOn<Playable> addon : this.myAnimation.getAddOns()) {
            a.addAddOn(addon);
        }
        return a;
    }

    public boolean containsLogicalId(int i) {
        return this.myAnimation.containsLogicalId(i);
    }

    public long getEnd() {
        long end = 0L;
        for (ChannelEditor mpc : this.myChildren) {
            long nEnd = mpc.getEnd();
            if (nEnd <= end) continue;
            end = nEnd;
        }
        return end;
    }

    @Override
    protected ChannelEditor createChildController(Channel channel) {
        return new ChannelEditor(channel, this.mySharedHistory);
    }

    @Override
    public boolean isChildUIController() {
        return true;
    }

    @Override
    protected int addChildBase(Object invoker, Source<Channel> channelSource, int i) {
        this.myAnimation.insertChannel(i, (Channel)channelSource.get());
        return this.myAnimation.getChannels().indexOf(channelSource.get());
    }

    @Override
    protected int insertChildControllerBase(ChannelEditor controller, int i) {
        Channel channel = controller.getChannel();
        this.myAnimation.insertChannel(i, channel);
        return this.myAnimation.getChannels().indexOf(channel);
    }
}

