/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.Transforms;
import org.robokind.api.animation.compiled.CompiledPath;
import org.robokind.api.animation.editor.AbstractEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.history.HistoryAction;
import org.robokind.api.animation.editor.history.HistoryHelper;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.common.localization.Localizer;
import org.robokind.api.common.utils.Source;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.interpolation.InterpolatorFactory;

public class MotionPathEditor
extends AbstractEditor<Point2D, ControlPointEditor> {
    private MotionPath myMotionPath;
    private MotionPath myTempPath;
    private boolean myIsDragging;
    private boolean myIsScaling;
    private boolean myIsMoving;
    private double myScaleAmount;
    private long myScaleRefTime;
    private int myDragStartIndex;
    private long myDragStartTime;
    private double myDragStartPos;
    private HistoryAction myDragHistCache;

    public MotionPathEditor(MotionPath mp, HistoryStack hist) {
        super(hist);
        this.myMotionPath = mp;
        this.myIsDragging = false;
        this.myIsMoving = false;
        this.myIsScaling = false;
        this.setChildren(this.myMotionPath.getControlPoints());
    }

    @Override
    public String getName() {
        String name = this.myMotionPath.getName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        int i = this.myParent == null ? -1 : this.myParent.getChildren().indexOf((Object)this);
        return i < 0 ? Localizer.$((String)"motion.path") : Localizer.$_((String)"motion.path") + i;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        String oldName = this.myMotionPath.getName();
        this.myMotionPath.setName(name);
        this.firePropertyChange("name", oldName, name);
    }

    @Override
    protected ControlPointEditor createChildController(Point2D point) {
        return new ControlPointEditor(point, this.mySharedHistory);
    }

    @Override
    public boolean isChildUIController() {
        return true;
    }

    @Override
    protected int addChildBase(Object invoker, Source<Point2D> p, int i) {
        if (this.isLocked()) {
            return -1;
        }
        long time = (long)Math.max(((Point2D)p.get()).getX(), 0.0);
        double pos = Utils.bound((double)((Point2D)p.get()).getY(), (double)0.0, (double)1.0);
        Point2D newP = this.myMotionPath.addPoint(time, pos);
        i = this.myMotionPath.getControlPoints().indexOf(newP);
        p.set((Object)newP);
        return i;
    }

    @Override
    protected int insertChildControllerBase(ControlPointEditor controller, int i) {
        Point2D p = controller.getSelected();
        Point2D n = this.myMotionPath.addPoint(p.getX(), p.getY());
        controller.setPoint(n);
        return this.myMotionPath.getControlPoints().indexOf(n);
    }

    public int size() {
        return this.myMotionPath.getControlPoints().size();
    }

    @Override
    protected Point2D removeChild(Object invoker, int i) {
        if (this.isLocked()) {
            return null;
        }
        return this.myMotionPath.removePoint(i);
    }

    public int dragSelectedPoint(Object invoker, long time, double pos, HistoryStack hist) {
        if (this.isLocked()) {
            return -1;
        }
        if (this.mySelectedIndex == -1) {
            return -1;
        }
        if (this.myTempPath == null) {
            this.startPathChange();
        }
        this.stopMoving(hist);
        this.stopScaling(hist);
        this.startDragging(false, this.mySelectedIndex);
        int i = this.movePoint(invoker, this.mySelectedIndex, time, pos, null);
        if (i != this.mySelectedIndex) {
            this.select(invoker, i, hist);
        }
        return this.mySelectedIndex;
    }

    public int movePoint(Object invoker, int i, long time, double pos, HistoryStack hist) {
        if (this.isLocked()) {
            return -1;
        }
        if (i == -1) {
            return -1;
        }
        time = Math.max(time, 0L);
        pos = Utils.bound((double)pos, (double)0.0, (double)1.0);
        int old = i;
        Point2D oldP = this.myMotionPath.getControlPoints().get(old);
        Point2D p = this.myMotionPath.setPoint(i, time, pos);
        i = this.myMotionPath.getControlPoints().indexOf(p);
        ControlPointEditor con = (ControlPointEditor)((Object)this.myChildren.remove(old));
        con.setPoint(p);
        this.myChildren.add(i, con);
        if (hist != null && hist != invoker) {
            hist.addEvent(HistoryHelper.movePoint(this, i, time, pos, old, (long)oldP.getX(), oldP.getY()));
        }
        this.fireItemMovedEvent(invoker, old, i);
        return i;
    }

    public MotionPath getTempPath() {
        return this.myTempPath;
    }

    public void startPathChange() {
        this.myTempPath = this.myMotionPath.clone();
    }

    public void endPathChange(boolean quiet, HistoryStack hist) {
        this.stopEverything(quiet, hist);
        if (this.myTempPath != null) {
            this.myTempPath = null;
            if (!quiet) {
                this.fireStructureChangedEvent((Object)this);
            }
        }
    }

    public void movePath(Object invoker, long timeOffset, double posOffset, HistoryStack hist) {
        if (this.isLocked()) {
            return;
        }
        this.stopScaling(hist);
        this.stopDragging(false, hist);
        if (this.myTempPath == null) {
            this.startPathChange();
        }
        this.startMoving();
        Transforms.translatePath(this.myTempPath, this.myMotionPath, timeOffset, posOffset);
        for (int i = 0; i < this.myChildren.size(); ++i) {
            this.fireItemMovedEvent(invoker, i, i);
        }
    }

    private void stopEverything(boolean quiet, HistoryStack hist) {
        this.stopScaling(hist);
        this.stopDragging(quiet, hist);
        this.stopMoving(hist);
    }

    public void scalePath(Object invoker, double scale, long refTime, HistoryStack hist) {
        if (this.isLocked()) {
            return;
        }
        this.stopDragging(false, hist);
        this.stopMoving(hist);
        if (this.myTempPath == null) {
            this.startPathChange();
        }
        this.startScaling(refTime);
        this.myScaleAmount *= scale;
        Transforms.scalePathTime(this.myTempPath, this.myMotionPath, this.myScaleAmount, this.myScaleRefTime);
        for (int i = 0; i < this.myChildren.size(); ++i) {
            this.fireItemMovedEvent(invoker, i, i);
        }
    }

    public void setPoints(Object invoker, List<Point2D> points, HistoryStack hist) {
        this.stopEverything(false, hist);
        Transforms.setPathControlPoints(this.myMotionPath, points);
        for (int i = 0; i < this.myChildren.size(); ++i) {
            this.fireItemMovedEvent(invoker, i, i);
        }
    }

    public void startDragging(boolean quiet, int index) {
        if (this.myIsDragging) {
            return;
        }
        this.myIsDragging = true;
        if (this.mySelectedIndex != index) {
            this.select((Object)this, index, this.mySharedHistory);
        }
        ControlPointEditor point = (ControlPointEditor)((Object)this.getSelected());
        Point2D p = point.getSelected();
        this.myDragStartIndex = this.mySelectedIndex;
        this.myDragStartTime = (long)p.getX();
        this.myDragStartPos = p.getY();
        if (!quiet) {
            point.startDragging();
        }
    }

    private void startScaling(long refTime) {
        if (!this.myIsScaling) {
            this.myIsScaling = true;
            this.myScaleAmount = 1.0;
            this.myScaleRefTime = refTime;
        }
    }

    private void startMoving() {
        if (!this.myIsMoving) {
            this.myIsMoving = true;
        }
    }

    private void stopDragging(boolean quiet, HistoryStack hist) {
        if (!this.myIsDragging) {
            return;
        }
        this.myIsDragging = false;
        this.myTempPath = null;
        ControlPointEditor point = (ControlPointEditor)((Object)this.getSelected());
        Point2D p = point.getSelected();
        this.myDragHistCache = HistoryHelper.movePoint(this, this.mySelectedIndex, (long)p.getX(), p.getY(), this.myDragStartIndex, this.myDragStartTime, this.myDragStartPos);
        if (hist != null) {
            hist.addEvent(this.myDragHistCache);
        }
        if (!quiet) {
            point.stopDragging();
        }
    }

    public HistoryAction getLastDragHistoryAction() {
        return this.myDragHistCache;
    }

    private void stopScaling(HistoryStack hist) {
        if (!this.myIsScaling) {
            return;
        }
        this.myIsScaling = false;
        if (hist != null) {
            HistoryAction event = HistoryHelper.scaleMotionPath(this, this.myTempPath.getControlPoints(), this.myMotionPath.getControlPoints());
            hist.addEvent(event);
        }
        if (this.myTempPath != null) {
            this.myTempPath = null;
        }
        this.fireStructureChangedEvent((Object)this);
    }

    private void stopMoving(HistoryStack hist) {
        if (!this.myIsMoving) {
            return;
        }
        this.myIsMoving = false;
        if (hist != null) {
            HistoryAction event = HistoryHelper.moveMotionPath(this, this.myTempPath.getControlPoints(), this.myMotionPath.getControlPoints());
            hist.addEvent(event);
        }
        if (this.myTempPath != null) {
            this.myTempPath = null;
        }
    }

    public CompiledPath getCompiledPath(long start, long end, long stepLength) {
        return this.myMotionPath.compilePath(start, end, stepLength);
    }

    public List<Point2D> getInterpolatedPoints() {
        return this.myMotionPath.getInterpolatedPoints();
    }

    public List<Point2D> getControlPoints() {
        return Collections.unmodifiableList(this.myMotionPath.getControlPoints());
    }

    public InterpolatorFactory getInterpolatorFactory() {
        return this.myMotionPath.getInterpolatorFactory();
    }

    public void setInterpolatorFactory(Object invoker, InterpolatorFactory factory, HistoryStack hist) {
        InterpolatorFactory prev = this.myMotionPath.getInterpolatorFactory();
        this.myMotionPath.setInterpolatorFactory(factory);
        if (hist != null && invoker != hist) {
            hist.addEvent(HistoryHelper.changeInterpolationFactory(this, factory, prev));
        }
        this.fireStructureChangedEvent(invoker);
    }

    public double getEnd() {
        if (this.myChildren.isEmpty()) {
            return 0.0;
        }
        return ((ControlPointEditor)((Object)this.myChildren.get(this.myChildren.size() - 1))).getSelected().getX();
    }

    public double getStart() {
        if (this.myChildren.isEmpty()) {
            return 0.0;
        }
        return ((ControlPointEditor)((Object)this.myChildren.get(0))).getSelected().getX();
    }

    @Override
    public void setState(Object invoker, EditState state, boolean value, HistoryStack hist) {
        if (this.hasFlag(state) == value) {
            return;
        }
        this.myStates = value ? (this.myStates |= state.getFlag().intValue()) : (this.myStates &= ~state.getFlag().intValue());
        if (state == EditState.DISABLED) {
            ((ChannelEditor)this.myParent).setEnabled(this.myMotionPath, !value);
        }
        if (hist != null && invoker != hist && EditState.isActionState(state)) {
            hist.addEvent(HistoryHelper.setState(this, state, value));
        }
        this.fireStateChangedEvent(invoker, state, value);
    }

    protected MotionPath getMotionPath() {
        return this.myMotionPath;
    }

    public boolean touchesControlPoints() {
        return this.myMotionPath.touchesControlPoints();
    }
}

