/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.robokind.api.animation.editor.AbstractEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.common.utils.Factory;

public abstract class EditorAction<T extends AbstractEditor<B, C>, B, C>
implements ActionListener {
    protected T myController;
    protected HistoryStack myHistory;

    public EditorAction(T editor) {
        this.myController = editor;
        this.myHistory = ((AbstractEditor)((Object)editor)).getSharedHistory();
    }

    public EditorAction(T controller, HistoryStack hist) {
        this.myController = controller;
        this.myHistory = hist;
    }

    public AbstractEditor getParent() {
        return ((AbstractEditor)((Object)this.myController)).getParent();
    }

    public HistoryStack getHistory() {
        return this.myHistory;
    }

    public void setHistory(HistoryStack hist) {
        this.myHistory = hist;
    }

    public static SetState Locked(AbstractEditor controller) {
        return new SetState(controller, EditState.LOCKED);
    }

    public static SetState Disabled(AbstractEditor controller) {
        return new SetState(controller, EditState.DISABLED);
    }

    public static SetState Visible(AbstractEditor controller) {
        return new SetState(controller, EditState.VISIBLE);
    }

    public static SetState Select(AbstractEditor controller) {
        return new SetSelect(controller);
    }

    public static class SetSelect<T extends AbstractEditor<B, C>, B, C>
    extends SetState<T, B, C> {
        public SetSelect(T controller) {
            super(controller, EditState.SELECTED);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditor parent = this.myController.getParent();
            int i = this.myValue ? parent.getChildren().indexOf((Object)this.myController) : -1;
            parent.select(e.getSource(), i, this.myHistory);
        }
    }

    public static class SetState<T extends AbstractEditor<B, C>, B, C>
    extends EditorAction<T, B, C> {
        private EditState myState;
        protected boolean myValue;

        public SetState(T controller, EditState state) {
            super(controller);
            this.myState = state;
            this.myValue = !((AbstractEditor)((Object)controller)).hasFlag(state);
        }

        public SetState(T controller, EditState state, boolean val) {
            super(controller);
            this.myState = state;
            this.myValue = val;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myController.setState(e.getSource(), this.myState, this.myValue, this.myHistory);
        }
    }

    public static class AddChildController<T extends AbstractEditor<B, C>, B, C>
    extends EditorAction<T, B, C> {
        private C myChild;
        private int myIndex;

        public AddChildController(T controller, C child, int i) {
            super(controller);
            this.myIndex = i;
            this.myChild = child;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myController.insertChildController(e.getSource(), this.myChild, this.myIndex, this.myHistory);
        }
    }

    public static class AddChild<T extends AbstractEditor<B, C>, B, C>
    extends EditorAction<T, B, C> {
        private Factory<B> myFactory;
        private boolean myValue;

        public AddChild(T controller, Factory<B> factory, boolean select) {
            super(controller);
            this.myValue = select;
            this.myFactory = factory;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int id = this.myController.addChild(e.getSource(), this.myFactory.create(), this.myHistory);
            if (this.myValue) {
                this.myController.select(e.getSource(), id, this.myHistory);
            }
        }
    }

    public static class RemoveChild<T extends AbstractEditor<B, C>, B, C>
    extends EditorAction<T, B, C> {
        private int myIndex;

        public RemoveChild(T controller, int i) {
            super(controller);
            this.myIndex = i;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myController.removeChildByIndex(e.getSource(), this.myIndex, this.myHistory);
        }
    }

    public static class Remove<T extends AbstractEditor<B, C>, B, C>
    extends EditorAction<T, B, C> {
        public Remove(T controller) {
            super(controller);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditor parent = this.getParent();
            if (parent == null) {
                return;
            }
            parent.removeChild(e.getSource(), this.myController, this.myHistory);
        }
    }
}

