/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.List;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.animation.editor.actions.EditorAction;
import org.robokind.api.animation.factory.ControlPointFactory;
import org.robokind.api.common.utils.ListUtils;
import org.robokind.api.interpolation.InterpolatorFactory;

public class MotionPathActions {
    public static EditorAction.Remove Remove(MotionPathEditor controller) {
        return new EditorAction.Remove(controller);
    }

    public static EditorAction.AddChild Add(MotionPathEditor controller, Point2D point) {
        return new EditorAction.AddChild(controller, new ControlPointFactory(point), false);
    }

    public static abstract class PathAction
    extends EditorAction<MotionPathEditor, Point2D, ControlPointEditor> {
        public PathAction(MotionPathEditor controller) {
            super(controller);
        }
    }

    public static class SetInterpolatorFactory
    extends PathAction {
        private InterpolatorFactory myFactory;

        public SetInterpolatorFactory(MotionPathEditor controller, InterpolatorFactory factory) {
            super(controller);
            this.myFactory = factory;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((MotionPathEditor)this.myController).setInterpolatorFactory(e.getSource(), this.myFactory, this.myHistory);
        }
    }

    public static class SetControlPoints
    extends PathAction {
        private List<Point2D> myPoints;

        public SetControlPoints(MotionPathEditor controller, List<Point2D> points) {
            super(controller);
            this.myPoints = ListUtils.deepCopy(points);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((MotionPathEditor)this.myController).setPoints(e.getSource(), this.myPoints, this.myHistory);
        }
    }

    public static class MovePoint
    extends PathAction {
        private int myIndex;
        private long myTime;
        private double myPosition;

        public MovePoint(MotionPathEditor controller, int i, long time, double pos) {
            super(controller);
            this.myIndex = i;
            this.myTime = time;
            this.myPosition = pos;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((MotionPathEditor)this.myController).movePoint(e.getSource(), this.myIndex, this.myTime, this.myPosition, this.myHistory);
        }
    }
}

