/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor.features;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robokind.api.animation.editor.AbstractEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.EditorListener;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.animation.editor.actions.EditorAction;
import org.robokind.api.animation.editor.history.DefaultHistoryAction;
import org.robokind.api.animation.editor.history.HistoryAction;
import org.robokind.api.animation.editor.history.HistoryActionGroup;
import org.robokind.api.animation.editor.history.HistoryStack;

public class SynchronizedPointGroup
extends EditorListener
implements PropertyChangeListener {
    private List<ControlPointEditor> myPoints;
    private HistoryStack mySharedHistory;

    public SynchronizedPointGroup(List<ControlPointEditor> points, HistoryStack hist, HistoryActionGroup addAction) {
        if (points == null || hist == null || addAction == null) {
            throw new NullPointerException();
        }
        this.myPoints = points;
        this.mySharedHistory = hist;
        this.setPoints();
        addAction.addEvent(new LinkPoints());
        this.mySharedHistory.addEvent(addAction);
    }

    private void setPoints() {
        for (ControlPointEditor point : this.myPoints) {
            point.setPointGroup(this);
            point.setUnlinkAction(new UnlinkAction(point, false));
            point.addPropertyChangeListener(this);
            AbstractEditor parent = point.getParent();
            if (parent == null) continue;
            MotionPathEditor parentPath = (MotionPathEditor)parent;
            parentPath.addConsumer(this);
        }
    }

    private void unsetPoints() {
        for (ControlPointEditor point : this.myPoints) {
            point.setPointGroup(null);
            point.setUnlinkAction(new UnlinkAction(point, false));
            point.removePropertyChangeListener(this);
            AbstractEditor parent = point.getParent();
            if (parent == null) continue;
            MotionPathEditor parentPath = (MotionPathEditor)parent;
            parentPath.removeConsumer(this);
        }
        this.myPoints.clear();
    }

    public void addPositions(Map<Integer, Double> positions) {
        for (ControlPointEditor point : this.myPoints) {
            ChannelEditor chan;
            AbstractEditor chanObj;
            MotionPathEditor path;
            AbstractEditor pathObj = point.getParent();
            if (pathObj == null || !(pathObj instanceof MotionPathEditor) || (path = (MotionPathEditor)pathObj).hasFlag(EditState.DISABLED) || !path.touchesControlPoints() || (chanObj = path.getParent()) == null || !(chanObj instanceof ChannelEditor) || (chan = (ChannelEditor)chanObj).hasFlag(EditState.DISABLED)) continue;
            int id = chan.getId();
            positions.put(id, point.getSelected().getY());
        }
    }

    @Override
    public void selectionChanged(Object invoker, Object editor, int oldIndex, int newIndex) {
    }

    @Override
    public void itemAdded(Object invoker, Object editor, int index) {
    }

    @Override
    public void itemRemoved(Object invoker, Object editor, int index) {
    }

    @Override
    public void itemMoved(Object invoker, Object editor, int oldIndex, int newIndex) {
        if (invoker == this || editor == null || !(editor instanceof MotionPathEditor)) {
            return;
        }
        MotionPathEditor path = (MotionPathEditor)((Object)editor);
        ControlPointEditor point = (ControlPointEditor)((Object)path.getChild(newIndex));
        if (!this.myPoints.contains((Object)point)) {
            return;
        }
        double time = point.getSelected().getX();
        for (ControlPointEditor p : this.myPoints) {
            MotionPathEditor parentPath;
            AbstractEditor parent;
            if (((Object)((Object)p)).equals((Object)point) || (parent = p.getParent()) == null || ((Object)((Object)(parentPath = (MotionPathEditor)parent))).equals((Object)path)) continue;
            int index = parentPath.getChildren().indexOf((Object)p);
            Point2D p2d = p.getSelected();
            double pos = p2d.getY();
            parentPath.movePoint(this, index, (long)time, pos, null);
        }
    }

    @Override
    public void stateChanged(Object invoker, Object controller, EditState state, boolean value) {
    }

    @Override
    public void structureChanged(Object invoker, Object controller) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object val = evt.getNewValue();
    }

    private void setGrouped(ControlPointEditor point, boolean val) {
        point.setPointGroup(val ? this : null);
    }

    public HistoryAction getUnlinkHistoryAction(ControlPointEditor point) {
        return new DefaultHistoryAction("Unlink Point", new UnlinkAction(point, true), new LinkAction(point), true);
    }

    public class LinkPoints
    implements HistoryAction {
        private List<ControlPointEditor> myLinkedPoints;
        private boolean myActionFlag = true;

        @Override
        public String getName() {
            return "Link Points";
        }

        @Override
        public void toggle(Object invoker) {
            if (this.myActionFlag) {
                this.undo(invoker);
            } else {
                this.redo(invoker);
            }
        }

        @Override
        public void undo(Object invoker) {
            if (!this.myActionFlag) {
                return;
            }
            this.myLinkedPoints = new ArrayList<ControlPointEditor>(SynchronizedPointGroup.this.myPoints);
            SynchronizedPointGroup.this.unsetPoints();
            this.myActionFlag = false;
        }

        @Override
        public void redo(Object invoker) {
            if (this.myActionFlag) {
                return;
            }
            SynchronizedPointGroup.this.myPoints = new ArrayList<ControlPointEditor>(this.myLinkedPoints);
            SynchronizedPointGroup.this.setPoints();
            this.myActionFlag = true;
        }

        @Override
        public boolean getActionPerformed() {
            return this.myActionFlag;
        }
    }

    public class LinkAction
    extends EditorAction<ControlPointEditor, Point2D, Point2D> {
        public LinkAction(ControlPointEditor editor) {
            super(editor);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SynchronizedPointGroup.this.setGrouped((ControlPointEditor)this.myController, true);
            SynchronizedPointGroup.this.myPoints.add(this.myController);
        }
    }

    public class UnlinkAction
    extends EditorAction<ControlPointEditor, Point2D, Point2D> {
        private boolean myQuietFlag;

        public UnlinkAction(ControlPointEditor editor, boolean quiet) {
            super(editor);
            this.myQuietFlag = quiet;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SynchronizedPointGroup.this.setGrouped((ControlPointEditor)this.myController, false);
            SynchronizedPointGroup.this.myPoints.remove((Object)this.myController);
            if (!this.myQuietFlag) {
                SynchronizedPointGroup.this.mySharedHistory.addEvent(SynchronizedPointGroup.this.getUnlinkHistoryAction((ControlPointEditor)this.myController));
            }
        }
    }
}

