/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.library;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.library.AnimationLibrary;
import org.robokind.api.animation.library.DefaultAnimationLibrary;
import org.robokind.api.animation.xml.AnimationFileReader;

public class AnimationLibraryLoader {
    private static final Logger theLogger = Logger.getLogger(AnimationLibraryLoader.class.getName());

    public AnimationLibrary loadAnimationFolder(String libraryId, AnimationFileReader reader, String path, boolean recursive) {
        if (libraryId == null || reader == null || path == null) {
            throw new NullPointerException();
        }
        File animDir = new File(path);
        List<File> files = this.getFiles(animDir, null, recursive);
        List<Animation> anims = this.loadAnimations(files, reader);
        DefaultAnimationLibrary lib = new DefaultAnimationLibrary(libraryId);
        for (Animation anim : anims) {
            lib.add(anim);
        }
        return lib;
    }

    private List<Animation> loadAnimations(List<File> files, AnimationFileReader reader) {
        ArrayList<Animation> anims = new ArrayList<Animation>(files.size());
        for (File file : files) {
            try {
                Animation anim = reader.readAnimation(file.getAbsolutePath());
                if (anim == null) continue;
                anims.add(anim);
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "Could not load animation at " + file.getAbsolutePath(), ex);
            }
        }
        return anims;
    }

    private List<File> getFiles(File animDir, FilenameFilter filenameFilter, boolean recursive) {
        if (!animDir.exists()) {
            throw new IllegalArgumentException("Cannot find dir: " + animDir);
        }
        if (!animDir.isDirectory()) {
            throw new IllegalArgumentException("Not a dir: " + animDir);
        }
        File[] files = filenameFilter == null ? animDir.listFiles() : animDir.listFiles(filenameFilter);
        ArrayList<File> fileList = new ArrayList<File>(files.length);
        ArrayList<File> dirList = new ArrayList<File>();
        for (File f : files) {
            if (f.isFile()) {
                fileList.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            dirList.add(f);
        }
        if (recursive) {
            for (File dir : dirList) {
                fileList.addAll(this.getFiles(dir, filenameFilter, recursive));
            }
        }
        return fileList;
    }
}

