/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.messaging.MessageAsyncReceiver;

public class RemoteAnimationPlayerHost {
    private static final Logger theLogger = Logger.getLogger(RemoteAnimationPlayerHost.class.getName());
    private AnimationPlayer myAnimationPlayer;
    private MessageAsyncReceiver<AnimationEvent> myAnimationReceiver;
    private AnimationEventPlayer myEventPlayer = new AnimationEventPlayer();

    public void setAnimationPlayer(AnimationPlayer player) {
        this.myAnimationPlayer = player;
    }

    public void setAnimationReceiver(MessageAsyncReceiver<AnimationEvent> receiver) {
        if (this.myAnimationReceiver != null) {
            this.myAnimationReceiver.removeMessageListener((Listener)this.myEventPlayer);
        }
        this.myAnimationReceiver = receiver;
        if (this.myAnimationReceiver != null) {
            this.myAnimationReceiver.addMessageListener((Listener)this.myEventPlayer);
        }
    }

    public class AnimationEventPlayer
    implements Listener<AnimationEvent> {
        public void handleEvent(AnimationEvent event) {
            if (event == null) {
                theLogger.warning("Ignoring null AnimaionEvent.");
                return;
            }
            Animation anim = event.getAnimation();
            if (anim == null) {
                theLogger.warning("Ignoring null Animaion from AnimationEvent.");
                return;
            }
            if (RemoteAnimationPlayerHost.this.myAnimationPlayer == null) {
                theLogger.warning("Animation Player is null.  Ignoring AnimaionEvent.");
                return;
            }
            theLogger.log(Level.INFO, "Sending Animation: {0}, to AnimationPlayer: {1}.", new Object[]{anim.getVersion().display(), RemoteAnimationPlayerHost.this.myAnimationPlayer.getAnimationPlayerId()});
            RemoteAnimationPlayerHost.this.myAnimationPlayer.playAnimation(event.getAnimation());
        }
    }
}

