/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.player;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.library.AnimationLibrary;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.triggering.Trigger;
import org.robokind.api.common.triggering.TriggerHandler;

public class AnimationTriggerHandler
implements TriggerHandler {
    private static final Logger theLogger = Logger.getLogger(AnimationTriggerHandler.class.getName());
    public static final String ANIMATION_TRIGGER_TYPE = "Animation";
    public static final String PROP_ANIMATION_NAME = "animationName";
    public static final String PROP_ANIMATION_VERSION = "animationVersion";
    private AnimationLibrary myLibrary;
    private AnimationPlayer myPlayer;

    public AnimationTriggerHandler(AnimationLibrary library, AnimationPlayer player) {
        this.myLibrary = library;
        this.myPlayer = player;
    }

    public void setAnimationLibrary(AnimationLibrary library) {
        this.myLibrary = library;
    }

    public void setPlayer(AnimationPlayer player) {
        this.myPlayer = player;
    }

    public void handleTrigger(Trigger trigger) {
        if (this.myLibrary == null || this.myPlayer == null) {
            theLogger.warning("Ignoring Trigger.  Library and Player must both be non null.");
            return;
        }
        if (trigger == null) {
            throw new NullPointerException();
        }
        if (!ANIMATION_TRIGGER_TYPE.equals(trigger.getTriggerType())) {
            theLogger.log(Level.WARNING, "Invalid TriggerType.  Expected: {0}, Found: {1}", new Object[]{ANIMATION_TRIGGER_TYPE, trigger.getTriggerType()});
            return;
        }
        Properties props = trigger.getTriggerProperties();
        if (props == null) {
            throw new NullPointerException("No animation version property");
        }
        String name = props.getProperty(PROP_ANIMATION_NAME);
        String number = props.getProperty(PROP_ANIMATION_VERSION);
        if (name == null || number == null) {
            throw new NullPointerException();
        }
        VersionProperty vp = new VersionProperty(name, number);
        this.playAnimation(vp);
    }

    private void playAnimation(VersionProperty vp) {
        Animation anim = this.myLibrary.getAnimation(vp);
        if (anim == null) {
            theLogger.log(Level.WARNING, "Unable to find Animation with VersionProperty: {0}.", vp.display());
            return;
        }
        this.myPlayer.playAnimation(anim);
    }

    public String getTriggerType() {
        return ANIMATION_TRIGGER_TYPE;
    }
}

