/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.xml;

import org.osgi.framework.ServiceException;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.xml.AnimationFileReader;
import org.robokind.api.animation.xml.AnimationFileWriter;
import org.robokind.api.common.osgi.ClassTracker;

public class AnimationXML {
    public static final String ANIMATION = "Animation";
    public static final String ANIMATION_VERSION_TYPE = "Animation";
    public static final String CHANNELS = "Channels";
    public static final String CHANNEL = "Channel";
    public static final String CHANNEL_ID = "id";
    public static final String CHANNEL_NAME = "name";
    public static final String MOTION_PATHS = "MotionPaths";
    public static final String MOTION_PATH = "MotionPath";
    public static final String MOTION_PATH_NAME = "name";
    public static final String INTERPOLATION_VERSION_TYPE = "Interpolation";
    public static final String CONTROL_POINTS = "ControlPoints";
    public static final String CONTROL_POINT = "ControlPoint";
    public static final String TIME = "Time";
    public static final String POSITION = "Position";
    public static final String ADDONS = "AddOns";
    public static final String ADDON = "AddOn";
    public static final String ADDON_FILE = "AddOnFile";
    public static final String NAMESPACE = null;
    private static ClassTracker<AnimationFileReader> myReaderTracker;
    private static ClassTracker<AnimationFileWriter> myWriterTracker;

    public static Animation loadAnimation(String path) throws ServiceException, Throwable {
        AnimationFileReader reader = AnimationXML.getReader();
        if (reader == null) {
            throw new ServiceException("No AnimationFileReader Service found.");
        }
        return reader.readAnimation(path);
    }

    public static void saveAnimation(String file, Animation a) throws ServiceException, Throwable {
        AnimationFileWriter writer = AnimationXML.getWriter();
        if (writer == null) {
            throw new ServiceException("No AnimationFileWriter Service found.");
        }
        writer.writeAnimation(file, a);
    }

    private static AnimationFileReader getReader() {
        if (myReaderTracker == null) {
            myReaderTracker = ClassTracker.build(AnimationFileReader.class, (String)"");
        }
        if (myReaderTracker == null) {
            return null;
        }
        return (AnimationFileReader)myReaderTracker.getTopService();
    }

    private static AnimationFileWriter getWriter() {
        if (myWriterTracker == null) {
            myWriterTracker = ClassTracker.build(AnimationFileWriter.class, (String)"");
        }
        if (myWriterTracker == null) {
            return null;
        }
        return (AnimationFileWriter)myWriterTracker.getTopService();
    }
}

