/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.interpolation.cspline;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.interpolation.Interpolator;
import org.robokind.api.interpolation.cspline.CSplineSegment;

public class CSplineInterpolator
implements Interpolator {
    public static final String VERSION_NAME = "C-Spline Interpolation";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("C-Spline Interpolation", "1.0");
    private List<Point2D> myPoints = new ArrayList<Point2D>();
    private Point2D[] myEndPoints;
    private List<Point2D> myInterpolatedPoints;
    private List<CSplineSegment> mySegments = new ArrayList<CSplineSegment>();

    public CSplineInterpolator() {
        this.myEndPoints = new Point2D[2];
    }

    @Override
    public Point2D addPoint(double x, double y) {
        return this.insertPoint(this.myPoints.size(), x, y);
    }

    @Override
    public Point2D insertPoint(int i, double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        this.myPoints.add(i, p);
        this.updateSplineForPoints(i, i);
        return p;
    }

    @Override
    public void addPoints(List<Point2D> points) {
        this.addPoints(this.myPoints.size(), points);
    }

    @Override
    public void addPoints(int i, List<Point2D> points) {
        this.myPoints.addAll(i, points);
        this.updateSplineForPoints(i, i + points.size() - 1);
    }

    @Override
    public Point2D setPoint(int i, double x, double y) {
        this.myPoints.get(i).setLocation(x, y);
        this.updateSplineForPoints(i, i);
        return this.myPoints.get(i);
    }

    @Override
    public void removePoint(Point2D p) {
        this.removePoint(this.myPoints.indexOf(p));
    }

    @Override
    public Point2D removePoint(int i) {
        Point2D p = this.myPoints.remove(i);
        i = Math.max(i - 1, 0);
        int j = Math.min(i, this.myPoints.size() - 1);
        this.updateSplineForPoints(i, j);
        return p;
    }

    private void updateSplineForPoints(int i, int j) {
        this.myInterpolatedPoints = null;
        this.updateSegmentListForPoint(i);
        int size = this.mySegments.size();
        if (size == 0) {
            return;
        }
        if (i < 2) {
            this.reflectStartPoint();
        }
        if (j >= size - 2) {
            this.reflectEndPoint();
        }
        int startSeg = Math.max(i - 2, 0);
        int endSeg = Math.min(j + 1, size - 1);
        for (int k = startSeg; k <= endSeg; ++k) {
            this.setSegment(k);
        }
    }

    private void setSegment(int i) {
        int segs = this.mySegments.size();
        if (i == 0 || i == segs - 1) {
            ArrayList<Point2D> points = new ArrayList<Point2D>(4);
            points.add(i <= 0 ? this.myEndPoints[0] : this.myPoints.get(i - 1));
            points.addAll(this.myPoints.subList(i, i + 2));
            points.add(i >= segs - 1 ? this.myEndPoints[1] : this.myPoints.get(i + 2));
            this.mySegments.set(i, new CSplineSegment(points));
        } else {
            this.mySegments.set(i, new CSplineSegment(this.myPoints.subList(i - 1, i + 3)));
        }
    }

    private void updateSegmentListForPoint(int i) {
        int count = this.myPoints.size() - this.mySegments.size() - 1;
        if (count > 0) {
            ArrayList<Object> emptySegments = new ArrayList<Object>(count);
            while (count > 0) {
                emptySegments.add(null);
                --count;
            }
            this.mySegments.addAll(Math.min(i, this.mySegments.size()), emptySegments);
        } else if (count < 0) {
            int j = Math.min(i - count, this.mySegments.size()) - 1;
            if (j + count + 1 < 0) {
                count = -j;
            }
            while (count < 0) {
                this.mySegments.remove(j);
                ++count;
                --j;
            }
        }
    }

    @Override
    public List<Point2D> getControlPoints() {
        return this.myPoints;
    }

    @Override
    public List<Point2D> getInterpolatedPoints() {
        if (this.myInterpolatedPoints != null) {
            return this.myInterpolatedPoints;
        }
        this.myInterpolatedPoints = new LinkedList<Point2D>();
        if (this.mySegments == null || this.mySegments.isEmpty()) {
            if (this.myPoints != null && !this.myPoints.isEmpty()) {
                this.myInterpolatedPoints.add(this.myPoints.get(0));
            }
            return this.myInterpolatedPoints;
        }
        for (CSplineSegment s : this.mySegments) {
            this.myInterpolatedPoints.addAll(s.getInterpolatedPoints());
        }
        return this.myInterpolatedPoints;
    }

    @Override
    public boolean interpolationChanged() {
        return this.myInterpolatedPoints == null;
    }

    @Override
    public void clear() {
        this.myPoints.clear();
        this.mySegments.clear();
        this.myInterpolatedPoints = null;
    }

    private void reflectStartPoint() {
        double x = 2.0 * this.myPoints.get(0).getX() - this.myPoints.get(1).getX();
        double y = 2.0 * this.myPoints.get(0).getY() - this.myPoints.get(1).getY();
        this.myEndPoints[0] = new Point2D.Double(x, y);
    }

    private void reflectEndPoint() {
        int n = this.myPoints.size() - 1;
        double x = 2.0 * this.myPoints.get(n).getX() - this.myPoints.get(n - 1).getX();
        double y = 2.0 * this.myPoints.get(n).getY() - this.myPoints.get(n - 1).getY();
        this.myEndPoints[1] = new Point2D.Double(x, y);
    }

    @Override
    public VersionProperty getInterpolatorVersion() {
        return VERSION;
    }

    @Override
    public boolean touchesControlPoints() {
        return true;
    }
}

