/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.EditorListener;
import org.robokind.api.animation.editor.history.HistoryHelper;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.common.localization.Localizer;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.common.utils.RKSource;

public abstract class AbstractEditor<ChildBase, ChildController>
extends PropertyChangeNotifier {
    public static final String PROP_NAME = "name";
    protected AbstractEditor myParent;
    protected List<ChildController> myChildren;
    protected List<EditorListener> myConsumers = new ArrayList<EditorListener>();
    protected List<EditorListener> myRecursiveConsumers = new ArrayList<EditorListener>();
    protected int mySelectedIndex = -1;
    protected int myStates;
    protected HistoryStack mySharedHistory;

    public AbstractEditor(HistoryStack hist) {
        this.myChildren = new ArrayList<ChildController>();
        this.myStates = EditState.getFlags(EditState.VISIBLE);
        this.mySharedHistory = hist;
    }

    public abstract void setName(String var1);

    public abstract String getName();

    protected abstract ChildBase removeChild(Object var1, int var2);

    protected abstract ChildController createChildController(ChildBase var1);

    public abstract boolean isChildUIController();

    protected abstract int addChildBase(Object var1, RKSource<ChildBase> var2, int var3);

    protected abstract int insertChildControllerBase(ChildController var1, int var2);

    protected void afterAddChild() {
    }

    public void setParent(AbstractEditor parent) {
        this.myParent = parent;
    }

    public AbstractEditor getParent() {
        return this.myParent;
    }

    public HistoryStack getSharedHistory() {
        return this.mySharedHistory;
    }

    public void addConsumer(EditorListener c) {
        if (!this.myConsumers.contains(c)) {
            this.myConsumers.add(c);
        }
    }

    public void recursiveAdd(EditorListener c) {
        if (!this.myRecursiveConsumers.contains(c)) {
            this.myRecursiveConsumers.add(c);
            this.removeConsumer(c);
        }
        if (this.myChildren.isEmpty()) {
            return;
        }
        if (!this.isChildUIController()) {
            return;
        }
        for (ChildController obj : this.myChildren) {
            ((AbstractEditor)((Object)obj)).recursiveAdd(c);
        }
    }

    protected void addRecursiveToChild(AbstractEditor child) {
        for (EditorListener c : this.myRecursiveConsumers) {
            child.recursiveAdd(c);
        }
    }

    public void removeConsumer(EditorListener c) {
        if (this.myConsumers.contains(c)) {
            this.myConsumers.remove(c);
        }
        c.stopConsuming(this);
    }

    public void recursiveRemove(EditorListener c) {
        if (!this.myRecursiveConsumers.contains(c)) {
            return;
        }
        this.myRecursiveConsumers.remove(c);
        if (!this.myChildren.isEmpty() && this.isChildUIController()) {
            for (ChildController obj : this.myChildren) {
                ((AbstractEditor)((Object)obj)).recursiveRemove(c);
            }
        }
        c.stopConsuming(this);
    }

    protected void removeFromConsumerList(EditorListener c) {
        if (this.myConsumers.contains(c)) {
            this.myConsumers.remove(c);
        }
    }

    protected void removeFromRecursiveList(EditorListener c) {
        if (this.myRecursiveConsumers.contains(c)) {
            this.myRecursiveConsumers.remove(c);
        }
    }

    public void clearConsumers() {
        for (EditorListener c : this.myConsumers) {
            c.stopConsuming(this);
        }
        for (EditorListener c : this.myRecursiveConsumers) {
            c.stopConsuming(this);
        }
    }

    public List<ChildController> getChildren() {
        return this.myChildren;
    }

    public ChildController getChild(int i) {
        if (i == -1) {
            return null;
        }
        return this.myChildren.get(i);
    }

    public ChildController getSelected() {
        if (this.mySelectedIndex == -1 || this.mySelectedIndex >= this.myChildren.size()) {
            return null;
        }
        return this.myChildren.get(this.mySelectedIndex);
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    public void select(Object invoker, int i, HistoryStack hist) {
        int old = this.mySelectedIndex;
        this.setSelected(old, false, hist);
        this.mySelectedIndex = i;
        if (i >= this.myChildren.size()) {
            this.mySelectedIndex = -1;
        }
        this.setSelected(i, true, hist);
        this.fireSelectionChangeEvent(invoker, old, this.mySelectedIndex);
    }

    protected void setSelected(int i, boolean sel, HistoryStack hist) {
        if (i < 0 || i >= this.myChildren.size()) {
            return;
        }
        ChildController c = this.getChild(i);
        if (c == null || !this.isChildUIController()) {
            return;
        }
        AbstractEditor child = (AbstractEditor)((Object)c);
        child.setState((Object)this, EditState.SELECTED, sel, hist);
    }

    public void deselect(Object invoker) {
        int old = this.mySelectedIndex;
        this.mySelectedIndex = -1;
        this.fireSelectionChangeEvent(invoker, old, this.mySelectedIndex);
    }

    public int addChild(Object invoker, ChildBase childBase, HistoryStack hist) {
        return this.insertChild(invoker, childBase, this.myChildren.size(), hist);
    }

    public int insertChild(Object invoker, ChildBase childBase, int i, HistoryStack hist) {
        if (this.isLocked()) {
            return -1;
        }
        RKSource.SourceImpl cSource = new RKSource.SourceImpl(childBase);
        if ((i = this.addChildBase(invoker, (RKSource<ChildBase>)cSource, i)) == -1) {
            return -1;
        }
        childBase = cSource.getValue();
        ChildController child = this.createChildController(childBase);
        this.myChildren.add(i, child);
        if (hist != null && invoker != hist && this.isChildUIController()) {
            String label = Localizer.$_((String)"add") + ((AbstractEditor)((Object)child)).getName();
            hist.addEvent(HistoryHelper.addChild(label, this, child, i));
        }
        if (this.isChildUIController()) {
            AbstractEditor uiController = (AbstractEditor)((Object)child);
            this.addRecursiveToChild(uiController);
            uiController.setParent(this);
        }
        this.afterAddChild();
        this.fireItemAddedEvent(invoker, i);
        return i;
    }

    public int insertChildController(Object invoker, ChildController controller, int i, HistoryStack hist) {
        if (this.isLocked()) {
            return -1;
        }
        if ((i = this.insertChildControllerBase(controller, i)) == -1) {
            return -1;
        }
        if (hist != null && invoker != hist && this.isChildUIController()) {
            String label = Localizer.$_((String)"add") + ((AbstractEditor)((Object)controller)).getName();
            hist.addEvent(HistoryHelper.addChild(label, this, controller, i));
        }
        this.myChildren.add(i, controller);
        if (this.isChildUIController()) {
            AbstractEditor uiController = (AbstractEditor)((Object)controller);
            uiController.myStates &= ~EditState.SELECTED.getFlag().intValue();
            this.addRecursiveToChild(uiController);
            uiController.setParent(this);
        }
        this.afterAddChild();
        this.fireItemAddedEvent(invoker, i);
        return i;
    }

    protected void setChildren(List<ChildBase> children) {
        this.myChildren.clear();
        for (ChildBase childBase : children) {
            ChildController child = this.createChildController(childBase);
            if (this.isChildUIController()) {
                AbstractEditor uiController = (AbstractEditor)((Object)child);
                this.addRecursiveToChild(uiController);
                uiController.setParent(this);
            }
            this.myChildren.add(child);
        }
    }

    public int removeChild(Object invoker, ChildController child, HistoryStack hist) {
        if (child == null) {
            return -1;
        }
        int i = this.myChildren.indexOf(child);
        if (i == -1) {
            return -1;
        }
        if (this.removeChildByIndex(invoker, i, hist) == null) {
            return -1;
        }
        return i;
    }

    public ChildController removeChildByIndex(Object invoker, int i, HistoryStack hist) {
        if (this.isLocked()) {
            return null;
        }
        int oldSel = this.mySelectedIndex;
        if (this.mySelectedIndex == i) {
            this.mySelectedIndex = -1;
        } else if (this.mySelectedIndex > i) {
            --this.mySelectedIndex;
        }
        ChildController cc = this.myChildren.remove(i);
        ChildBase base = this.removeChild(invoker, i);
        if (base == null) {
            this.myChildren.add(i, cc);
            this.mySelectedIndex = oldSel;
            return null;
        }
        if (this.isChildUIController()) {
            AbstractEditor editor = (AbstractEditor)((Object)cc);
            if (hist != null && invoker != hist) {
                String label = Localizer.$_((String)"remove") + editor.getName();
                hist.addEvent(HistoryHelper.removeChild(label, this, cc, i));
            }
            AbstractEditor.clearDescendentConsumers(editor);
            editor.clearConsumers();
        }
        this.fireItemRemovedEvent(invoker, i);
        return cc;
    }

    private static void clearDescendentConsumers(AbstractEditor editor) {
        if (!editor.isChildUIController()) {
            return;
        }
        for (AbstractEditor child : editor.getChildren()) {
            AbstractEditor.clearDescendentConsumers(child);
            child.clearConsumers();
        }
    }

    public void setState(Object invoker, EditState state, boolean value, HistoryStack hist) {
        if (this.hasFlag(state) == value) {
            return;
        }
        this.myStates = value ? (this.myStates |= state.getFlag().intValue()) : (this.myStates &= ~state.getFlag().intValue());
        if (hist != null && invoker != hist && EditState.isActionState(state)) {
            hist.addEvent(HistoryHelper.setState(this, state, value));
        }
        this.fireStateChangedEvent(invoker, state, value);
    }

    public int getInheritedFlags() {
        if (this.myParent != null) {
            return this.myStates | this.myParent.getInheritedFlags();
        }
        return this.myStates;
    }

    public int getRestrictiveFlags() {
        if (this.myParent != null) {
            return this.myStates & this.myParent.getInheritedFlags();
        }
        return this.myStates;
    }

    public int getStateFlags() {
        return this.myStates;
    }

    public List<EditState> getStates() {
        return EditState.getFlags(this.myStates);
    }

    public boolean hasFlag(EditState state) {
        return EditState.hasFlag(this.myStates, state);
    }

    public boolean isLocked() {
        boolean locked = this.hasFlag(EditState.LOCKED);
        if (locked) {
            return locked;
        }
        return this.myParent != null && this.myParent.hasFlag(EditState.LOCKED);
    }

    protected final void fireSelectionChangeEvent(final Object invoker, final int oldIndex, final int newIndex) {
        this.invokeAction(new Runnable(){

            @Override
            public void run() {
                AbstractEditor.this.fireSelectionChangeEvent(invoker, oldIndex, newIndex, AbstractEditor.this.myConsumers);
                AbstractEditor.this.fireSelectionChangeEvent(invoker, oldIndex, newIndex, AbstractEditor.this.myRecursiveConsumers);
            }
        });
    }

    protected final void fireSelectionChangeEvent(Object invoker, int oldIndex, int newIndex, List<EditorListener> cs) {
        for (int i = 0; i < cs.size(); ++i) {
            EditorListener consumer = cs.get(i);
            if (consumer == invoker) continue;
            consumer.selectionChanged(invoker, (Object)this, oldIndex, newIndex);
        }
    }

    protected final void fireItemAddedEvent(final Object invoker, final int index) {
        this.invokeAction(new Runnable(){

            @Override
            public void run() {
                AbstractEditor.this.fireItemAddedEvent(invoker, index, AbstractEditor.this.myConsumers);
                AbstractEditor.this.fireItemAddedEvent(invoker, index, AbstractEditor.this.myRecursiveConsumers);
            }
        });
    }

    protected final void fireItemAddedEvent(Object invoker, int index, List<EditorListener> cs) {
        for (int i = 0; i < cs.size(); ++i) {
            EditorListener consumer = cs.get(i);
            if (consumer == invoker) continue;
            consumer.itemAdded(invoker, (Object)this, index);
        }
    }

    protected final void fireItemRemovedEvent(final Object invoker, final int oldIndex) {
        this.invokeAction(new Runnable(){

            @Override
            public void run() {
                AbstractEditor.this.fireItemRemovedEvent(invoker, oldIndex, AbstractEditor.this.myConsumers);
                AbstractEditor.this.fireItemRemovedEvent(invoker, oldIndex, AbstractEditor.this.myRecursiveConsumers);
            }
        });
    }

    protected final void fireItemRemovedEvent(Object invoker, int oldIndex, List<EditorListener> cs) {
        for (int i = 0; i < cs.size(); ++i) {
            EditorListener consumer = cs.get(i);
            if (consumer == invoker) continue;
            consumer.itemRemoved(invoker, (Object)this, oldIndex);
        }
    }

    protected final void fireItemMovedEvent(final Object invoker, final int oldIndex, final int newIndex) {
        this.invokeAction(new Runnable(){

            @Override
            public void run() {
                AbstractEditor.this.fireItemMovedEvent(invoker, oldIndex, newIndex, AbstractEditor.this.myConsumers);
                AbstractEditor.this.fireItemMovedEvent(invoker, oldIndex, newIndex, AbstractEditor.this.myRecursiveConsumers);
            }
        });
    }

    protected final void fireItemMovedEvent(Object invoker, int oldIndex, int newIndex, List<EditorListener> cs) {
        for (int i = 0; i < cs.size(); ++i) {
            EditorListener consumer = cs.get(i);
            if (consumer == invoker) continue;
            consumer.itemMoved(invoker, (Object)this, oldIndex, newIndex);
        }
    }

    protected final void fireStateChangedEvent(final Object invoker, final EditState state, final boolean value) {
        this.invokeAction(new Runnable(){

            @Override
            public void run() {
                AbstractEditor.this.fireStateChangedEvent(invoker, state, value, AbstractEditor.this.myConsumers);
                AbstractEditor.this.fireStateChangedEvent(invoker, state, value, AbstractEditor.this.myRecursiveConsumers);
            }
        });
    }

    protected final void fireStateChangedEvent(Object invoker, EditState state, boolean value, List<EditorListener> cs) {
        for (int i = 0; i < cs.size(); ++i) {
            EditorListener consumer = cs.get(i);
            if (consumer == invoker) continue;
            consumer.stateChanged(invoker, (Object)this, state, value);
        }
    }

    protected final void fireStructureChangedEvent(final Object invoker) {
        this.invokeAction(new Runnable(){

            @Override
            public void run() {
                AbstractEditor.this.fireStructureChangedEvent(invoker, AbstractEditor.this.myConsumers);
                AbstractEditor.this.fireStructureChangedEvent(invoker, AbstractEditor.this.myRecursiveConsumers);
            }
        });
    }

    protected final void fireStructureChangedEvent(Object invoker, List<EditorListener> cs) {
        for (int i = 0; i < cs.size(); ++i) {
            EditorListener consumer = cs.get(i);
            if (consumer == invoker) continue;
            consumer.structureChanged(invoker, (Object)this);
        }
    }

    private void invokeAction(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }
}

