/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor.history;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import org.robokind.api.animation.editor.AbstractEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.animation.editor.actions.ChannelActions;
import org.robokind.api.animation.editor.actions.EditorAction;
import org.robokind.api.animation.editor.actions.MotionPathActions;
import org.robokind.api.animation.editor.history.DefaultHistoryAction;
import org.robokind.api.animation.editor.history.HistoryAction;
import org.robokind.api.common.localization.Localizer;
import org.robokind.api.interpolation.InterpolatorFactory;

public class HistoryHelper {
    public static HistoryAction setState(AbstractEditor controller, EditState state, boolean val) {
        EditorAction.SetState undo = new EditorAction.SetState(controller, state, !val);
        EditorAction.SetState redo = new EditorAction.SetState(controller, state, val);
        return new DefaultHistoryAction(Localizer.$((String)"set.state"), redo, undo, true);
    }

    public static <B, C> HistoryAction removeChild(String label, AbstractEditor<B, C> controller, C child, int i) {
        EditorAction.AddChildController undo = new EditorAction.AddChildController(controller, child, i);
        EditorAction.RemoveChild redo = new EditorAction.RemoveChild(controller, i);
        return new DefaultHistoryAction(label, redo, undo, true);
    }

    public static <B, C> HistoryAction addChild(String label, AbstractEditor<B, C> controller, C child, int i) {
        EditorAction.RemoveChild undo = new EditorAction.RemoveChild(controller, i);
        EditorAction.AddChildController redo = new EditorAction.AddChildController(controller, child, i);
        return new DefaultHistoryAction(label, redo, undo, true);
    }

    public static HistoryAction changeColor(ChannelEditor controller, Color cur, Color prev) {
        ChannelActions.ChangeColor undo = new ChannelActions.ChangeColor(controller, prev);
        ChannelActions.ChangeColor redo = new ChannelActions.ChangeColor(controller, cur);
        return new DefaultHistoryAction(Localizer.$((String)"change.color"), redo, undo, true);
    }

    public static HistoryAction changeInterpolationFactory(MotionPathEditor controller, InterpolatorFactory curFactory, InterpolatorFactory prevFactory) {
        MotionPathActions.SetInterpolatorFactory undo = new MotionPathActions.SetInterpolatorFactory(controller, prevFactory);
        MotionPathActions.SetInterpolatorFactory redo = new MotionPathActions.SetInterpolatorFactory(controller, curFactory);
        return new DefaultHistoryAction(Localizer.$((String)"change.interpolation"), redo, undo, true);
    }

    public static HistoryAction scaleMotionPath(MotionPathEditor controller, List<Point2D> prevPoints, List<Point2D> newPoints) {
        MotionPathActions.SetControlPoints undo = new MotionPathActions.SetControlPoints(controller, prevPoints);
        MotionPathActions.SetControlPoints redo = new MotionPathActions.SetControlPoints(controller, newPoints);
        return new DefaultHistoryAction(Localizer.$((String)"scale.motion.path"), redo, undo, true);
    }

    public static HistoryAction moveMotionPath(MotionPathEditor controller, List<Point2D> prevPoints, List<Point2D> newPoints) {
        MotionPathActions.SetControlPoints undo = new MotionPathActions.SetControlPoints(controller, prevPoints);
        MotionPathActions.SetControlPoints redo = new MotionPathActions.SetControlPoints(controller, newPoints);
        return new DefaultHistoryAction(Localizer.$((String)"move.motion.path"), redo, undo, true);
    }

    public static HistoryAction movePoint(MotionPathEditor controller, int curI, long curTime, double curPos, int prevI, long prevTime, double prevPos) {
        MotionPathActions.MovePoint undo = new MotionPathActions.MovePoint(controller, curI, prevTime, prevPos);
        MotionPathActions.MovePoint redo = new MotionPathActions.MovePoint(controller, prevI, curTime, curPos);
        return new DefaultHistoryAction(Localizer.$((String)"move.control.point"), redo, undo, true);
    }
}

