/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.messaging;

import java.util.List;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.messaging.RemoteAnimationJob;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.MessageSender;

public class RemoteAnimationPlayerClient
implements AnimationPlayer {
    private String myAnimationPlayerId;
    private String myRemotePlayerId;
    private MessageSender<AnimationEvent> myAnimationSender;
    private AnimationEvent.AnimationEventFactory myEventFactory;
    private List<RemoteAnimationJob> myAnimationJobs;

    public RemoteAnimationPlayerClient(String animPlayerClientId, String animPlayerHostId) {
        if (animPlayerClientId == null || animPlayerHostId == null) {
            throw new NullPointerException();
        }
        this.myAnimationPlayerId = animPlayerClientId;
        this.myRemotePlayerId = animPlayerHostId;
    }

    @Override
    public String getAnimationPlayerId() {
        return this.myAnimationPlayerId;
    }

    public void setAnimationEventFactory(AnimationEvent.AnimationEventFactory factory) {
        this.myEventFactory = factory;
    }

    public void setAnimationEventSender(MessageSender<AnimationEvent> sender) {
        this.myAnimationSender = sender;
    }

    @Override
    public AnimationJob playAnimation(Animation animation) {
        if (this.myEventFactory == null || this.myAnimationSender == null) {
            return null;
        }
        AnimationEvent event = this.myEventFactory.createAnimationEvent(this.myAnimationPlayerId, this.myRemotePlayerId, animation);
        this.myAnimationSender.notifyListeners((Object)event);
        for (ServiceAddOn<Playable> add : animation.getAddOns()) {
            ((Playable)add.getAddOn()).start(TimeUtils.now());
        }
        RemoteAnimationJob job = new RemoteAnimationJob(this, animation, animation.getStartTime(), animation.getStopTime(), 800);
        job.start(TimeUtils.now());
        return job;
    }

    public AnimationJob loopAnimation(Animation animation) {
        if (this.myEventFactory == null || this.myAnimationSender == null) {
            return null;
        }
        AnimationEvent event = this.myEventFactory.createAnimationEvent(this.myAnimationPlayerId, "LOOP", animation);
        this.myAnimationSender.notifyListeners((Object)event);
        for (ServiceAddOn<Playable> add : animation.getAddOns()) {
            ((Playable)add.getAddOn()).start(TimeUtils.now());
        }
        RemoteAnimationJob job = new RemoteAnimationJob(this, animation, animation.getStartTime(), animation.getStopTime(), 800);
        job.start(TimeUtils.now());
        return job;
    }

    public void stopAnimation(Animation animation) {
        if (this.myEventFactory == null || this.myAnimationSender == null) {
            return;
        }
        AnimationEvent event = this.myEventFactory.createAnimationEvent(this.myAnimationPlayerId, "STOP", animation);
        this.myAnimationSender.notifyListeners((Object)event);
        for (ServiceAddOn<Playable> add : animation.getAddOns()) {
            ((Playable)add.getAddOn()).stop(TimeUtils.now());
        }
    }

    public void clearAnimations() {
        if (this.myEventFactory == null || this.myAnimationSender == null) {
            return;
        }
        Animation empty = new Animation(new VersionProperty("empty", "1.0"));
        empty.addChannel(new Channel(0, "emptyChan"));
        MotionPath path = new MotionPath();
        path.addPoint(0.0, 0.5);
        path.addPoint(1.0, 0.5);
        empty.getChannel(0).addPath(path);
        AnimationEvent event = this.myEventFactory.createAnimationEvent(this.myAnimationPlayerId, "CLEAR", empty);
        this.myAnimationSender.notifyListeners((Object)event);
    }

    @Override
    public AnimationJob playAnimation(Animation animation, Long start, Long stop) {
        animation.setStartTime(start);
        animation.setStopTime(stop);
        return this.playAnimation(animation);
    }

    @Override
    public List<AnimationJob> getCurrentAnimations() {
        return this.myAnimationJobs;
    }

    @Override
    public void removeAnimationJob(AnimationJob job) {
        if (!(job instanceof RemoteAnimationJob)) {
            return;
        }
        RemoteAnimationJob rjob = (RemoteAnimationJob)job;
        if (!this.myAnimationJobs.contains(rjob)) {
            return;
        }
        rjob.stop(TimeUtils.now());
        this.myAnimationJobs.remove(rjob);
    }
}

