/*
 * Copyright 2013 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.animation.messaging;

import java.util.Map;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationJobListener;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.common.playable.AbstractPlayable;
import org.robokind.api.common.playable.PlayState;

/**
 *
 * @author matt
 */
public class RemoteAnimationJob extends AbstractPlayable implements AnimationJob {
    private RemoteAnimationPlayerClient myPlayer;
    private Animation myAnimation;
    private long myMaxRampTimeMillisec;
    private boolean myLoopFlag;
    private long myAnimStartTime;
    private long myEndTime;

    RemoteAnimationJob(RemoteAnimationPlayerClient player, Animation anim, Long start, Long stop, int maxRampMillisec){
        if(anim == null || player == null){
            throw new NullPointerException();
        }
        myPlayer = player;
        myLoopFlag = false;
        myAnimation = anim;
        myMaxRampTimeMillisec = maxRampMillisec;
        myAnimStartTime = start == null || start < 0 ? 0 : start;
        myEndTime = stop == null || stop < 0 ? anim.getLength() : stop;
    }
    @Override
    public AnimationPlayer getSource() {
        return myPlayer;
    }
    
    @Override
    public void addAnimationListener(AnimationJobListener listener) {}
    
    @Override
    public void removeAnimationListener(AnimationJobListener listener) {}
    
    @Override
    public Animation getAnimation(){
        return myAnimation;
    }
    
    public Long getCurrentTime(long time){
        Long l = getElapsedPlayTime(time);
        if(l == null){
            return null;
        }
        return l+myAnimStartTime;
    }
    
    @Override
    public Map<Integer,Double> advanceAnimation(long time, long interval){
        return null;
    }

    @Override
    public boolean onStart(long time) {
        return true;
    }
    
    @Override
    public Long getAnimationLength(){
        return myEndTime - myAnimStartTime  + myMaxRampTimeMillisec;
    }
    
    @Override
    public Long getRemainingTime(long time){
        long now = getElapsedPlayTime(time);
        long end = getAnimationLength();
        return end - now;
    }

    @Override
    protected boolean onPause(long time) {
        return true;
    }
    @Override
    protected boolean onResume(long time) {
        return true;
    }
    @Override
    protected boolean onStop(long time) {
        myPlayer.stopAnimation(myAnimation);
        return true;
    }
    @Override
    protected boolean onComplete(long time) {
        return true;
    }

    @Override
    public void setLoop(boolean loop) {
        if(loop){
            myPlayer.loopAnimation(myAnimation);
        }else if(myPlayState == PlayState.RUNNING){
            myPlayer.playAnimation(myAnimation);
        }
        myLoopFlag = loop;
    }

    @Override
    public boolean getLoop() {
        return myLoopFlag;
    }
}
