/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor.features;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.animation.editor.AbstractEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.features.SynchronizedPointGroup;

public class SyncPointGroupConfig {
    public static SyncGroupConfig createConfig(SynchronizedPointGroup group) {
        List<ControlPointEditor> points = group.getPoints();
        ArrayList<SyncPointConfig> pointConfs = new ArrayList<SyncPointConfig>(points.size());
        for (ControlPointEditor point : points) {
            SyncPointConfig conf = SyncPointGroupConfig.createPointConfig(point);
            if (conf == null) continue;
            pointConfs.add(conf);
        }
        if (pointConfs.isEmpty()) {
            return null;
        }
        return new SyncGroupConfig(pointConfs);
    }

    static SyncPointConfig createPointConfig(ControlPointEditor point) {
        if (point == null) {
            return null;
        }
        AbstractEditor path = point.getParent();
        if (path == null) {
            return null;
        }
        AbstractEditor channel = path.getParent();
        if (channel == null || !(channel instanceof ChannelEditor)) {
            return null;
        }
        int chanId = ((ChannelEditor)channel).getId();
        int pathId = SyncPointGroupConfig.getChildIndex(channel, path);
        int pointId = SyncPointGroupConfig.getChildIndex(path, point);
        if (chanId < 0 || pathId < 0 || pointId < 0) {
            return null;
        }
        return new SyncPointConfig(chanId, pathId, pointId);
    }

    static int getChildIndex(AbstractEditor parent, AbstractEditor child) {
        List children = parent.getChildren();
        if (children == null) {
            return -1;
        }
        return children.indexOf((Object)child);
    }

    public static class SyncGroupConfig {
        public List<SyncPointConfig> points;

        public SyncGroupConfig(List<SyncPointConfig> points) {
            this.points = points;
        }
    }

    public static class SyncPointConfig {
        public int channelId;
        public int motionPathId;
        public int controlPointId;

        public SyncPointConfig(int channelId, int motionPathId, int controlPointId) {
            this.channelId = channelId;
            this.motionPathId = motionPathId;
            this.controlPointId = controlPointId;
        }
    }
}

