/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerClient;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.messaging.MessageSender;

public class AnimationPlayerClientLifecycle
extends AbstractLifecycleProvider<AnimationPlayer, RemoteAnimationPlayerClient> {
    private static final String theAnimationSender = "animSender";
    private static final String theAnimationEventFactory = "animEventFactory";
    private String myPlayerClientId;
    private String myPlayerHostId;

    public AnimationPlayerClientLifecycle(String animPlayerId, String remotePlayerId, String animSenderId) {
        super(new DescriptorListBuilder().dependency(theAnimationSender, MessageSender.class).with("messageSenderId", animSenderId).with("messageType", AnimationEvent.class.getName()).dependency(theAnimationEventFactory, AnimationEvent.AnimationEventFactory.class).getDescriptors());
        if (animPlayerId == null || remotePlayerId == null) {
            throw new NullPointerException();
        }
        this.myPlayerClientId = animPlayerId;
        this.myPlayerHostId = remotePlayerId;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("animationPlayerId", animPlayerId);
        this.myServiceClassNames = new String[]{AnimationPlayer.class.getName(), RemoteAnimationPlayerClient.class.getName()};
    }

    protected RemoteAnimationPlayerClient create(Map<String, Object> dependencies) {
        MessageSender sender = (MessageSender)dependencies.get(theAnimationSender);
        AnimationEvent.AnimationEventFactory factory = (AnimationEvent.AnimationEventFactory)dependencies.get(theAnimationEventFactory);
        RemoteAnimationPlayerClient client = new RemoteAnimationPlayerClient(this.myPlayerClientId, this.myPlayerHostId);
        client.setAnimationEventFactory(factory);
        client.setAnimationEventSender((MessageSender<AnimationEvent>)sender);
        return client;
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myService == null) {
            return;
        }
        if (theAnimationSender.equals(name)) {
            ((RemoteAnimationPlayerClient)this.myService).setAnimationEventSender((MessageSender<AnimationEvent>)((MessageSender)dependency));
        } else if (theAnimationEventFactory.equals(name)) {
            ((RemoteAnimationPlayerClient)this.myService).setAnimationEventFactory((AnimationEvent.AnimationEventFactory)dependency);
        }
    }

    public Class<AnimationPlayer> getServiceClass() {
        return AnimationPlayer.class;
    }
}

