/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.interpolation;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.osgi.ClassTracker;
import org.robokind.api.interpolation.InterpolatorFactory;
import org.robokind.api.interpolation.cspline.CSplineInterpolatorFactory;

public class InterpolatorDirectory {
    private static final Logger theLogger = Logger.getLogger(InterpolatorDirectory.class.getName());
    public static final String INTERPOLATOR_VERSION = "InterpolatorVersion";
    private static final String theFilterTemplate = String.format("(&(%s=%s)(%s=%s))", "objectClass", InterpolatorFactory.class.getName(), "InterpolatorVersion", "%s");
    private static InterpolatorDirectory theInstance;
    private static List<InterpolatorFactory> theFactories;
    private static Map<VersionProperty, InterpolatorFactory> theFactoryMap;
    private BundleContext myContext = null;
    private ClassTracker<InterpolatorFactory> myFactoryTracker;
    private List<InterpolatorFactory> myFactories;
    private Map<VersionProperty, ServiceTracker> myOSGiFactories = new HashMap<VersionProperty, ServiceTracker>();
    private InterpolatorFactory myDefaultFactory = null;
    private boolean myIsUsingOSGi = false;

    public static InterpolatorDirectory instance() {
        if (theInstance == null) {
            theInstance = new InterpolatorDirectory(new CSplineInterpolatorFactory());
        }
        return theInstance;
    }

    private static Map<VersionProperty, InterpolatorFactory> getFactoryMap() {
        if (theFactoryMap == null) {
            theFactoryMap = new HashMap<VersionProperty, InterpolatorFactory>();
        }
        return theFactoryMap;
    }

    private static List<InterpolatorFactory> getAllFactories() {
        if (theFactories == null) {
            theFactories = new ArrayList<InterpolatorFactory>();
        }
        return theFactories;
    }

    static void registerFactory(InterpolatorFactory fact) {
        InterpolatorDirectory.getFactoryMap().put(fact.getVersion(), fact);
        InterpolatorDirectory.getAllFactories().add(fact);
    }

    public static ServiceRegistration registerFactory(BundleContext context, InterpolatorFactory fact) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(INTERPOLATOR_VERSION, fact.getVersion().toString());
        return context.registerService(InterpolatorFactory.class.getName(), (Object)fact, props);
    }

    private InterpolatorDirectory(InterpolatorFactory defaultFactory) {
        this();
        this.myDefaultFactory = defaultFactory;
    }

    public InterpolatorDirectory() {
        this.myFactoryTracker = new ClassTracker(InterpolatorFactory.class.getName());
        this.myFactories = new ArrayList<InterpolatorFactory>();
    }

    public InterpolatorFactory getDefaultFactory() {
        return this.myDefaultFactory;
    }

    public InterpolatorFactory getFactory(VersionProperty version) {
        if (version == null) {
            return this.myDefaultFactory;
        }
        InterpolatorFactory factory = null;
        if (this.myIsUsingOSGi) {
            factory = this.getFactory(this.myContext, version);
        } else if (InterpolatorDirectory.getFactoryMap().containsKey(version)) {
            factory = InterpolatorDirectory.getFactoryMap().get(version);
        }
        if (factory == null && this.myDefaultFactory != null) {
            theLogger.log(Level.WARNING, "Unable to find InterpolatorFactory with Version={0}. Using default Factory.", version);
            factory = this.myDefaultFactory;
        }
        return factory;
    }

    public List<InterpolatorFactory> buildFactoryList() {
        List factories = null;
        factories = this.myIsUsingOSGi ? this.myFactoryTracker.getServices() : InterpolatorDirectory.getAllFactories();
        this.myFactories.clear();
        if (factories != null && !factories.isEmpty()) {
            for (InterpolatorFactory factory : factories) {
                this.myFactories.add(factory);
            }
        }
        if (this.myFactories.isEmpty() && this.myDefaultFactory != null) {
            this.myFactories.add(this.myDefaultFactory);
        }
        return this.myFactories;
    }

    public void setDefault(InterpolatorFactory factory) {
        if (factory != null) {
            this.myDefaultFactory = factory;
        }
    }

    public void setContext(BundleContext context) {
        this.myIsUsingOSGi = context != null;
        this.myContext = context;
        if (this.myIsUsingOSGi) {
            this.myFactoryTracker.setContext(this.myContext);
            this.myFactoryTracker.init();
        }
    }

    public void useOSGi(boolean val) {
        this.myIsUsingOSGi = val;
    }

    private InterpolatorFactory getFactory(BundleContext context, VersionProperty version) {
        if (context == null) {
            return null;
        }
        InterpolatorFactory factory = InterpolatorDirectory.buildTrackedFactory(this.myOSGiFactories.get(version));
        if (factory != null) {
            return factory;
        }
        String filterStr = String.format(theFilterTemplate, version.toString());
        try {
            Filter filter = context.createFilter(filterStr);
            ServiceTracker tracker = new ServiceTracker(context, filter, null);
            tracker.open();
            this.myOSGiFactories.put(version, tracker);
            return InterpolatorDirectory.buildTrackedFactory(tracker);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Could not get ServiceTracker for InterpolatorFactory.  Bad version filter (" + filterStr + ").", ex);
        }
        catch (IllegalStateException ex) {
            theLogger.log(Level.WARNING, "Unable to create ServiceTracker.", ex);
        }
        return null;
    }

    private static InterpolatorFactory buildTrackedFactory(ServiceTracker tracker) {
        if (tracker == null) {
            return null;
        }
        Object obj = tracker.getService();
        if (obj == null || !(obj instanceof InterpolatorFactory)) {
            return null;
        }
        return (InterpolatorFactory)obj;
    }
}

