package org.robokind.api.audio.osgi;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.audio.WavBufferPlayer;
import org.robokind.api.audio.config.WavPlayerServiceFactory;
import org.robokind.api.common.services.ServiceConfigurationLoader;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.common.services.ServiceUtils;

public class Activator implements BundleActivator {
    private final static Logger theLogger = 
            Logger.getLogger(Activator.class.getName());

    @Override
    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "org.robokind.api.audio Activation Begin.");
        ServiceRegistration factReg = ServiceUtils.registerServiceFactory(
                context, new WavPlayerServiceFactory(), null);
        theLogger.log(Level.INFO, 
                "org.robokind.api.audio Activation Complete.");
    }

    public void stop(BundleContext context) throws Exception {
        // TODO add deactivation code here
    }

}
