/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.audio.processing;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import org.robokind.api.audio.WavBuffer;
import org.robokind.api.audio.processing.AudioConverter;
import org.robokind.api.audio.processing.SampleProcessor;
import org.robokind.api.audio.processing.VisualizationConverter;
import org.robokind.api.audio.processing.WavProcessor;
import org.robokind.api.common.utils.Utils;

public class WavBufferProcessor
implements WavProcessor {
    private static final Logger theLogger = Logger.getLogger(WavBufferProcessor.class.getName());
    private static final int theDefaultBufferSize = 512;
    private AudioConverter myConverter;
    private int myBufferSamples;
    private double myAudioLengthSeconds;
    private long myAudioLengthFrames;
    private int mySampleSize;
    private byte[] myAudio;
    private int myStartIndex;
    private int myProcIndex;
    private int myStopIndex;
    private int myBufferSize;
    private AudioFormat myFormat;

    public WavBufferProcessor(WavBuffer wav, int startByte, int stopByte) {
        this.myAudio = wav.getAudioBytes();
        this.myBufferSamples = 512;
        this.myFormat = wav.getFormat();
        this.myStartIndex = Utils.bound((int)startByte, (int)0, (int)(this.myAudio.length - 1));
        this.myStopIndex = Utils.bound((int)stopByte, (int)(this.myStartIndex + 1), (int)this.myAudio.length);
        this.myProcIndex = this.myStartIndex;
        this.initAudioStream();
    }

    public WavBufferProcessor(WavBuffer wav) {
        this.myAudio = wav.getAudioBytes();
        this.myBufferSamples = 512;
        this.myFormat = wav.getFormat();
        this.myStartIndex = 0;
        this.myStopIndex = this.myAudio.length;
        this.myProcIndex = this.myStartIndex;
        this.initAudioStream();
    }

    private void initAudioStream() {
        int frameSize = this.myFormat.getFrameSize();
        int audioLen = this.myStopIndex - this.myStartIndex;
        this.myAudioLengthFrames = audioLen /= frameSize;
        float frameRate = this.myFormat.getFrameRate();
        this.myAudioLengthSeconds = (float)this.myAudioLengthFrames / frameRate;
        int bytesPerSample = this.myFormat.getSampleSizeInBits() / 8;
        boolean signed = this.myFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        this.myConverter = new VisualizationConverter(this.myFormat.getChannels(), bytesPerSample, signed, this.myFormat.isBigEndian());
        this.mySampleSize = bytesPerSample * this.myFormat.getChannels();
        this.myBufferSize = this.myBufferSamples * this.mySampleSize;
    }

    @Override
    public void setSamplesBufferSize(int size) {
        this.myBufferSamples = size;
        this.myBufferSize = this.myBufferSamples * this.mySampleSize;
    }

    @Override
    public int getSamplesBufferSize() {
        return this.myBufferSamples;
    }

    @Override
    public void reset() {
        this.myProcIndex = this.myStartIndex;
    }

    @Override
    public double getLengthSeconds() {
        return this.myAudioLengthSeconds;
    }

    @Override
    public long getFrameCount() {
        return this.myAudioLengthFrames;
    }

    @Override
    public AudioFormat getFormat() {
        return this.myFormat;
    }

    @Override
    public void process(SampleProcessor processor) {
        byte[] buffer = new byte[this.myBufferSize];
        int count = 0;
        boolean processing = true;
        while (processing) {
            int processed;
            processing = (long)(count += (processed = this.processBuffer(buffer, processor, count))) != this.myAudioLengthFrames && processed > 0;
        }
    }

    private int processBuffer(byte[] buffer, SampleProcessor processor, int count) {
        if (this.myProcIndex == this.myStopIndex) {
            return 0;
        }
        try {
            int play = this.myProcIndex;
            int remaining = this.myStopIndex - play;
            int len = Math.min(remaining, buffer.length);
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this.myAudio, this.myProcIndex, buffer, 0, len);
            double[][] samples = this.myConverter.convert(buffer);
            processor.processSamples(samples, count + len, (int)this.getFrameCount());
            this.myProcIndex += len;
            return len;
        }
        catch (Exception e) {
            theLogger.log(Level.WARNING, "Error Processing.", e);
            return 0;
        }
    }
}

