/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WavBuffer {
    private static final Logger theLogger = Logger.getLogger(WavBuffer.class.getName());
    private long myAudioLengthFrames;
    private byte[] myAudio;
    private String myAudioLocation;
    private AudioFormat myFormat;

    public WavBuffer(File wavFile) throws FileNotFoundException, IOException, LineUnavailableException, UnsupportedAudioFileException {
        if (wavFile == null) {
            throw new NullPointerException();
        }
        if (!wavFile.exists()) {
            throw new FileNotFoundException("Wave file not found: " + wavFile);
        }
        this.myAudioLocation = wavFile.getAbsolutePath();
        AudioInputStream audioStream = AudioSystem.getAudioInputStream(wavFile);
        this.myFormat = audioStream.getFormat();
        this.myFormat.getEncoding();
        int bytesPerFrame = this.myFormat.getFrameSize();
        this.myAudioLengthFrames = (int)audioStream.getFrameLength();
        int audioLen = (int)((long)bytesPerFrame * this.myAudioLengthFrames);
        this.myAudio = new byte[audioLen];
        int totalRead = 0;
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = audioStream.read(this.myAudio, totalRead, audioLen - totalRead);
            if (bytesRead < 0) continue;
            totalRead += bytesRead;
        }
        if (totalRead != audioLen) {
            theLogger.log(Level.WARNING, "Could not read full audio file.  Read {0}bytes out of {1}.", new Object[]{totalRead, audioLen});
        }
    }

    public WavBuffer(byte[] audio, AudioFormat format) {
        this.myAudio = audio;
        this.myFormat = format;
        int frameSize = this.myFormat.getFrameSize();
        int audioLen = this.myAudio.length;
        this.myAudioLengthFrames = audioLen /= frameSize;
    }

    public byte[] getAudioBytes() {
        return this.myAudio;
    }

    public long getFrameCount() {
        return this.myAudioLengthFrames;
    }

    public AudioFormat getFormat() {
        return this.myFormat;
    }

    public String getAudioLocation() {
        return this.myAudioLocation;
    }
}

